/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.m7.trading.api.xjb;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public final class XSDateTimeCustomBinder {
    private static final TimeZone XML_TZ = TimeZone.getTimeZone("UTC");
    private static DatatypeFactory factory;
    private static final ThreadLocal<GregorianCalendar> CALENDAR_THREAD_LOCAL;

    private XSDateTimeCustomBinder() {
    }

    public static Date parseDateTime(String s) {
        if (s == null || s.length() < 1) {
            return null;
        }
        return factory.newXMLGregorianCalendar(s).toGregorianCalendar().getTime();
    }

    public static String printDateTime(Date dt) {
        if (dt == null) {
            return null;
        }
        GregorianCalendar calendar = CALENDAR_THREAD_LOCAL.get();
        calendar.setTime(dt);
        return factory.newXMLGregorianCalendar(calendar).toXMLFormat();
    }

    static {
        try {
            factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        CALENDAR_THREAD_LOCAL = new ThreadLocal<GregorianCalendar>(){

            @Override
            protected GregorianCalendar initialValue() {
                return new GregorianCalendar(XML_TZ);
            }
        };
    }
}

