/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.binding;

import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.ObservableValueBase;

public abstract class DependentObservableValue<S, T>
extends ObservableValueBase<T> {
    private final T defaultValue;
    private final InvalidationListener invalidationListener;
    private final ChangeListener<S> changeListener;
    private final ObjectProperty<ObservableValue<T>> nestedValue;

    public DependentObservableValue(ObservableValue<S> s, Observable ... dependencies) {
        this(s, null, dependencies);
    }

    public DependentObservableValue(ObservableValue<S> s, T defaultValue, Observable ... dependencies) {
        this.defaultValue = defaultValue;
        this.nestedValue = new SimpleObjectProperty<ObservableValue<T>>();
        this.invalidationListener = this.decorateInvalidator(new Invalidator());
        s.addListener(this.invalidationListener);
        for (Observable dependency : dependencies) {
            dependency.addListener(this.invalidationListener);
        }
        this.nestedValue.addListener((ObservableValue<? super T> observableValue, ? super T oldValue, ? super T newValue) -> {
            if (oldValue != null) {
                oldValue.removeListener(this.invalidationListener);
            }
            if (newValue != null) {
                newValue.addListener(this.invalidationListener);
            }
            this.invalidationListener.invalidated(this.nestedValue);
        });
        this.changeListener = (paramObservableValue, oldValue, newValue) -> {
            if (newValue != null) {
                this.nestedValue.setValue(this.getObservableValue(newValue));
            } else {
                this.nestedValue.setValue(null);
            }
        };
        s.addListener(this.changeListener);
        if (s.getValue() != null) {
            this.nestedValue.setValue(this.getObservableValue(s.getValue()));
        }
    }

    public static <S, T> DependentObservableValue<S, T> get(ObservableValue<S> s, Function<S, ObservableValue<T>> property, Observable ... dependencies) {
        return DependentObservableValue.get(s, property, null, dependencies);
    }

    public static <S, T> DependentObservableValue<S, T> get(ObservableValue<S> s, final Function<S, ObservableValue<T>> property, T defaultValue, Observable ... dependencies) {
        return new DependentObservableValue<S, T>(s, defaultValue, dependencies){

            @Override
            public ObservableValue<T> getObservableValue(S s) {
                return (ObservableValue)property.apply(s);
            }
        };
    }

    public abstract ObservableValue<T> getObservableValue(S var1);

    protected InvalidationListener decorateInvalidator(Invalidator invalidator) {
        return invalidator;
    }

    @Override
    public T getValue() {
        ObservableValue currentNestedValue = (ObservableValue)this.nestedValue.getValue();
        if (currentNestedValue != null) {
            return currentNestedValue.getValue();
        }
        return this.defaultValue;
    }

    protected class Invalidator
    implements InvalidationListener {
        protected Invalidator() {
        }

        @Override
        public void invalidated(Observable paramObservable) {
            DependentObservableValue.this.fireValueChangedEvent();
        }
    }
}

