/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.OrderedIterator;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.ResettableIterator;
import org.apache.commons.collections4.ResettableListIterator;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.iterators.ArrayIterator;
import org.apache.commons.collections4.iterators.ArrayListIterator;
import org.apache.commons.collections4.iterators.BoundedIterator;
import org.apache.commons.collections4.iterators.CollatingIterator;
import org.apache.commons.collections4.iterators.EmptyIterator;
import org.apache.commons.collections4.iterators.EmptyListIterator;
import org.apache.commons.collections4.iterators.EmptyMapIterator;
import org.apache.commons.collections4.iterators.EmptyOrderedIterator;
import org.apache.commons.collections4.iterators.EmptyOrderedMapIterator;
import org.apache.commons.collections4.iterators.EnumerationIterator;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.apache.commons.collections4.iterators.FilterListIterator;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.commons.collections4.iterators.IteratorEnumeration;
import org.apache.commons.collections4.iterators.IteratorIterable;
import org.apache.commons.collections4.iterators.LazyIteratorChain;
import org.apache.commons.collections4.iterators.ListIteratorWrapper;
import org.apache.commons.collections4.iterators.LoopingIterator;
import org.apache.commons.collections4.iterators.LoopingListIterator;
import org.apache.commons.collections4.iterators.NodeListIterator;
import org.apache.commons.collections4.iterators.ObjectArrayIterator;
import org.apache.commons.collections4.iterators.ObjectArrayListIterator;
import org.apache.commons.collections4.iterators.ObjectGraphIterator;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.apache.commons.collections4.iterators.PushbackIterator;
import org.apache.commons.collections4.iterators.SingletonIterator;
import org.apache.commons.collections4.iterators.SingletonListIterator;
import org.apache.commons.collections4.iterators.SkippingIterator;
import org.apache.commons.collections4.iterators.TransformIterator;
import org.apache.commons.collections4.iterators.UnmodifiableIterator;
import org.apache.commons.collections4.iterators.UnmodifiableListIterator;
import org.apache.commons.collections4.iterators.UnmodifiableMapIterator;
import org.apache.commons.collections4.iterators.ZippingIterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IteratorUtils {
    public static final ResettableIterator EMPTY_ITERATOR = EmptyIterator.RESETTABLE_INSTANCE;
    public static final ResettableListIterator EMPTY_LIST_ITERATOR = EmptyListIterator.RESETTABLE_INSTANCE;
    public static final OrderedIterator EMPTY_ORDERED_ITERATOR = EmptyOrderedIterator.INSTANCE;
    public static final MapIterator EMPTY_MAP_ITERATOR = EmptyMapIterator.INSTANCE;
    public static final OrderedMapIterator EMPTY_ORDERED_MAP_ITERATOR = EmptyOrderedMapIterator.INSTANCE;
    private static final String DEFAULT_TOSTRING_DELIMITER = ", ";

    private static <E, C extends Collection<E>> C addAll(Iterator<? extends E> iterator2, C list) {
        Objects.requireNonNull(iterator2, "iterator");
        while (iterator2.hasNext()) {
            list.add(iterator2.next());
        }
        return list;
    }

    public static <E> ResettableIterator<E> arrayIterator(E ... array) {
        return new ObjectArrayIterator<E>(array);
    }

    public static <E> ResettableIterator<E> arrayIterator(E[] array, int start) {
        return new ObjectArrayIterator<E>(array, start);
    }

    public static <E> ResettableIterator<E> arrayIterator(E[] array, int start, int end) {
        return new ObjectArrayIterator<E>(array, start, end);
    }

    public static <E> ResettableIterator<E> arrayIterator(Object array) {
        return new ArrayIterator(array);
    }

    public static <E> ResettableIterator<E> arrayIterator(Object array, int start) {
        return new ArrayIterator(array, start);
    }

    public static <E> ResettableIterator<E> arrayIterator(Object array, int start, int end) {
        return new ArrayIterator(array, start, end);
    }

    public static <E> ResettableListIterator<E> arrayListIterator(E ... array) {
        return new ObjectArrayListIterator<E>(array);
    }

    public static <E> ResettableListIterator<E> arrayListIterator(E[] array, int start) {
        return new ObjectArrayListIterator<E>(array, start);
    }

    public static <E> ResettableListIterator<E> arrayListIterator(E[] array, int start, int end) {
        return new ObjectArrayListIterator<E>(array, start, end);
    }

    public static <E> ResettableListIterator<E> arrayListIterator(Object array) {
        return new ArrayListIterator(array);
    }

    public static <E> ResettableListIterator<E> arrayListIterator(Object array, int start) {
        return new ArrayListIterator(array, start);
    }

    public static <E> ResettableListIterator<E> arrayListIterator(Object array, int start, int end) {
        return new ArrayListIterator(array, start, end);
    }

    public static <E> Enumeration<E> asEnumeration(Iterator<? extends E> iterator2) {
        return new IteratorEnumeration<E>(Objects.requireNonNull(iterator2, "iterator"));
    }

    public static <E> Iterable<E> asIterable(Iterator<? extends E> iterator2) {
        Objects.requireNonNull(iterator2, "iterator");
        return new IteratorIterable<E>(iterator2, false);
    }

    public static <E> Iterator<E> asIterator(Enumeration<? extends E> enumeration) {
        return new EnumerationIterator<E>(Objects.requireNonNull(enumeration, "enumeration"));
    }

    public static <E> Iterator<E> asIterator(Enumeration<? extends E> enumeration, Collection<? super E> removeCollection) {
        return new EnumerationIterator<E>(Objects.requireNonNull(enumeration, "enumeration"), Objects.requireNonNull(removeCollection, "removeCollection"));
    }

    public static <E> Iterable<E> asMultipleUseIterable(Iterator<? extends E> iterator2) {
        Objects.requireNonNull(iterator2, "iterator");
        return new IteratorIterable<E>(iterator2, true);
    }

    public static <E> BoundedIterator<E> boundedIterator(Iterator<? extends E> iterator2, long max) {
        return IteratorUtils.boundedIterator(iterator2, 0L, max);
    }

    public static <E> BoundedIterator<E> boundedIterator(Iterator<? extends E> iterator2, long offset, long max) {
        return new BoundedIterator<E>(iterator2, offset, max);
    }

    public static <E> Iterator<E> chainedIterator(Collection<? extends Iterator<? extends E>> iterators) {
        return new IteratorChain(iterators);
    }

    public static <E> Iterator<E> chainedIterator(Iterator<? extends E> ... iterators) {
        return new IteratorChain<E>(iterators);
    }

    public static <E> Iterator<E> chainedIterator(Iterator<? extends E> iterator1, Iterator<? extends E> iterator2) {
        return new IteratorChain<E>(iterator1, iterator2);
    }

    public static <E> Iterator<E> chainedIterator(final Iterator<? extends Iterator<? extends E>> iterators) {
        return new LazyIteratorChain<E>(){

            @Override
            protected Iterator<? extends E> nextIterator(int count) {
                return iterators.hasNext() ? (Iterator)iterators.next() : null;
            }
        };
    }

    public static <E> Iterator<E> collatedIterator(Comparator<? super E> comparator, Collection<Iterator<? extends E>> iterators) {
        Comparator<? super E> comp = comparator == null ? ComparatorUtils.NATURAL_COMPARATOR : comparator;
        return new CollatingIterator<E>(comp, iterators);
    }

    public static <E> Iterator<E> collatedIterator(Comparator<? super E> comparator, Iterator<? extends E> ... iterators) {
        Comparator<? super E> comp = comparator == null ? ComparatorUtils.NATURAL_COMPARATOR : comparator;
        return new CollatingIterator<E>(comp, iterators);
    }

    public static <E> Iterator<E> collatedIterator(Comparator<? super E> comparator, Iterator<? extends E> iterator1, Iterator<? extends E> iterator2) {
        Comparator<? super E> comp = comparator == null ? ComparatorUtils.NATURAL_COMPARATOR : comparator;
        return new CollatingIterator<E>(comp, iterator1, iterator2);
    }

    public static <E> boolean contains(Iterator<E> iterator2, Object object) {
        return IteratorUtils.matchesAny(iterator2, EqualPredicate.equalPredicate(object));
    }

    public static <E> ResettableIterator<E> emptyIterator() {
        return EmptyIterator.resettableEmptyIterator();
    }

    public static <E> ResettableListIterator<E> emptyListIterator() {
        return EmptyListIterator.resettableEmptyListIterator();
    }

    public static <K, V> MapIterator<K, V> emptyMapIterator() {
        return EmptyMapIterator.emptyMapIterator();
    }

    public static <E> OrderedIterator<E> emptyOrderedIterator() {
        return EmptyOrderedIterator.emptyOrderedIterator();
    }

    public static <K, V> OrderedMapIterator<K, V> emptyOrderedMapIterator() {
        return EmptyOrderedMapIterator.emptyOrderedMapIterator();
    }

    public static <E> Iterator<E> filteredIterator(Iterator<? extends E> iterator2, Predicate<? super E> predicate) {
        Objects.requireNonNull(iterator2, "iterator");
        Objects.requireNonNull(predicate, "predicate");
        return new FilterIterator<E>(iterator2, predicate);
    }

    public static <E> ListIterator<E> filteredListIterator(ListIterator<? extends E> listIterator2, Predicate<? super E> predicate) {
        Objects.requireNonNull(listIterator2, "listIterator");
        Objects.requireNonNull(predicate, "predicate");
        return new FilterListIterator<E>(listIterator2, predicate);
    }

    public static <E> E find(Iterator<E> iterator2, Predicate<? super E> predicate) {
        return IteratorUtils.find(iterator2, predicate, null);
    }

    private static <E> E find(Iterator<E> iterator2, Predicate<? super E> predicate, E defaultValue) {
        Objects.requireNonNull(predicate, "predicate");
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                E element = iterator2.next();
                if (!predicate.test(element)) continue;
                return element;
            }
        }
        return defaultValue;
    }

    public static <E> E first(Iterator<E> iterator2) {
        return IteratorUtils.get(iterator2, 0);
    }

    public static <E> void forEach(Iterator<E> iterator2, Closure<? super E> closure) {
        Objects.requireNonNull(closure, "closure");
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                closure.accept(iterator2.next());
            }
        }
    }

    public static <E> E forEachButLast(Iterator<E> iterator2, Closure<? super E> closure) {
        Objects.requireNonNull(closure, "closure");
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                E element = iterator2.next();
                if (!iterator2.hasNext()) {
                    return element;
                }
                closure.accept(element);
            }
        }
        return null;
    }

    public static <E> E get(Iterator<E> iterator2, int index) {
        return (E)IteratorUtils.get(iterator2, index, ioob -> {
            throw new IndexOutOfBoundsException("Entry does not exist: " + ioob);
        });
    }

    static <E> E get(Iterator<E> iterator2, int index, IntFunction<E> defaultSupplier) {
        int i = index;
        CollectionUtils.checkIndexBounds(i);
        while (iterator2.hasNext()) {
            if (--i == -1) {
                return iterator2.next();
            }
            iterator2.next();
        }
        return defaultSupplier.apply(i);
    }

    public static Iterator<?> getIterator(Object obj) {
        if (obj == null) {
            return IteratorUtils.emptyIterator();
        }
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator();
        }
        if (obj instanceof Object[]) {
            return new ObjectArrayIterator<Object>((Object[])obj);
        }
        if (obj instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().iterator();
        }
        if (obj instanceof NodeList) {
            return new NodeListIterator((NodeList)obj);
        }
        if (obj instanceof Node) {
            return new NodeListIterator((Node)obj);
        }
        if (obj instanceof Dictionary) {
            return new EnumerationIterator(((Dictionary)obj).elements());
        }
        if (obj.getClass().isArray()) {
            return new ArrayIterator(obj);
        }
        try {
            Iterator it;
            Method method = obj.getClass().getMethod("iterator", null);
            if (Iterator.class.isAssignableFrom(method.getReturnType()) && (it = (Iterator)method.invoke(obj, (Object[])null)) != null) {
                return it;
            }
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            // empty catch block
        }
        return IteratorUtils.singletonIterator(obj);
    }

    public static <E> int indexOf(Iterator<E> iterator2, Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        if (iterator2 != null) {
            int index = 0;
            while (iterator2.hasNext()) {
                E element = iterator2.next();
                if (predicate.test(element)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public static boolean isEmpty(Iterator<?> iterator2) {
        return iterator2 == null || !iterator2.hasNext();
    }

    public static <E> ResettableIterator<E> loopingIterator(Collection<? extends E> collection) {
        return new LoopingIterator<E>(Objects.requireNonNull(collection, "collection"));
    }

    public static <E> ResettableListIterator<E> loopingListIterator(List<E> list) {
        return new LoopingListIterator<E>(Objects.requireNonNull(list, "list"));
    }

    public static <E> boolean matchesAll(Iterator<E> iterator2, Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                E element = iterator2.next();
                if (predicate.test(element)) continue;
                return false;
            }
        }
        return true;
    }

    public static <E> boolean matchesAny(Iterator<E> iterator2, Predicate<? super E> predicate) {
        return IteratorUtils.indexOf(iterator2, predicate) != -1;
    }

    public static NodeListIterator nodeListIterator(Node node) {
        return new NodeListIterator(Objects.requireNonNull(node, "node"));
    }

    public static NodeListIterator nodeListIterator(NodeList nodeList) {
        return new NodeListIterator(Objects.requireNonNull(nodeList, "nodeList"));
    }

    public static <E> Iterator<E> objectGraphIterator(E root, Transformer<? super E, ? extends E> transformer) {
        return new ObjectGraphIterator<E>(root, transformer);
    }

    public static <E> Iterator<E> peekingIterator(Iterator<? extends E> iterator2) {
        return PeekingIterator.peekingIterator(iterator2);
    }

    public static <E> Iterator<E> pushbackIterator(Iterator<? extends E> iterator2) {
        return PushbackIterator.pushbackIterator(iterator2);
    }

    public static <E> ResettableIterator<E> singletonIterator(E object) {
        return new SingletonIterator<E>(object);
    }

    public static <E> ListIterator<E> singletonListIterator(E object) {
        return new SingletonListIterator<E>(object);
    }

    public static int size(Iterator<?> iterator2) {
        int size = 0;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                iterator2.next();
                ++size;
            }
        }
        return size;
    }

    public static <E> SkippingIterator<E> skippingIterator(Iterator<E> iterator2, long offset) {
        return new SkippingIterator<E>(iterator2, offset);
    }

    public static <E> Stream<E> stream(Iterable<E> iterable) {
        return iterable == null ? Stream.empty() : StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <E> Stream<E> stream(Iterator<E> iterator2) {
        return iterator2 == null ? Stream.empty() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator2, 16), false);
    }

    public static Object[] toArray(Iterator<?> iterator2) {
        Objects.requireNonNull(iterator2, "iterator");
        List<?> list = IteratorUtils.toList(iterator2, 100);
        return list.toArray();
    }

    public static <E> E[] toArray(Iterator<? extends E> iterator2, Class<E> arrayClass) {
        Objects.requireNonNull(iterator2, "iterator");
        Objects.requireNonNull(arrayClass, "arrayClass");
        List<E> list = IteratorUtils.toList(iterator2, 100);
        Object[] array = (Object[])Array.newInstance(arrayClass, list.size());
        return list.toArray(array);
    }

    public static <E> List<E> toList(Iterator<? extends E> iterator2) {
        return IteratorUtils.toList(iterator2, 10);
    }

    public static <E> List<E> toList(Iterator<? extends E> iterator2, int estimatedSize) {
        if (estimatedSize < 1) {
            throw new IllegalArgumentException("Estimated size must be greater than 0");
        }
        return IteratorUtils.addAll(iterator2, new ArrayList(estimatedSize));
    }

    public static <E> ListIterator<E> toListIterator(Iterator<? extends E> iterator2) {
        Objects.requireNonNull(iterator2, "iterator");
        return new ListIteratorWrapper<E>(iterator2);
    }

    public static <E> Set<E> toSet(Iterator<? extends E> iterator2) {
        return IteratorUtils.toSet(iterator2, 10);
    }

    public static <E> Set<E> toSet(Iterator<? extends E> iterator2, int estimatedSize) {
        if (estimatedSize < 1) {
            throw new IllegalArgumentException("Estimated size must be greater than 0");
        }
        return IteratorUtils.addAll(iterator2, new HashSet(estimatedSize));
    }

    public static <E> String toString(Iterator<E> iterator2) {
        return IteratorUtils.toString(iterator2, TransformerUtils.stringValueTransformer(), DEFAULT_TOSTRING_DELIMITER, "[", "]");
    }

    public static <E> String toString(Iterator<E> iterator2, Transformer<? super E, String> transformer) {
        return IteratorUtils.toString(iterator2, transformer, DEFAULT_TOSTRING_DELIMITER, "[", "]");
    }

    public static <E> String toString(Iterator<E> iterator2, Transformer<? super E, String> transformer, String delimiter, String prefix, String suffix) {
        Objects.requireNonNull(transformer, "transformer");
        Objects.requireNonNull(delimiter, "delimiter");
        Objects.requireNonNull(prefix, "prefix");
        Objects.requireNonNull(suffix, "suffix");
        StringBuilder stringBuilder = new StringBuilder(prefix);
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                E element = iterator2.next();
                stringBuilder.append(transformer.apply(element));
                stringBuilder.append(delimiter);
            }
            if (stringBuilder.length() > prefix.length()) {
                stringBuilder.setLength(stringBuilder.length() - delimiter.length());
            }
        }
        stringBuilder.append(suffix);
        return stringBuilder.toString();
    }

    public static <I, O> Iterator<O> transformedIterator(Iterator<? extends I> iterator2, Transformer<? super I, ? extends O> transformer) {
        Objects.requireNonNull(iterator2, "iterator");
        Objects.requireNonNull(transformer, "transformer");
        return new TransformIterator<I, O>(iterator2, transformer);
    }

    public static <E> Iterator<E> unmodifiableIterator(Iterator<E> iterator2) {
        return UnmodifiableIterator.unmodifiableIterator(iterator2);
    }

    public static <E> ListIterator<E> unmodifiableListIterator(ListIterator<E> listIterator2) {
        return UnmodifiableListIterator.unmodifiableListIterator(listIterator2);
    }

    public static <K, V> MapIterator<K, V> unmodifiableMapIterator(MapIterator<K, V> mapIterator) {
        return UnmodifiableMapIterator.unmodifiableMapIterator(mapIterator);
    }

    public static <E> ZippingIterator<E> zippingIterator(Iterator<? extends E> ... iterators) {
        return new ZippingIterator<E>(iterators);
    }

    public static <E> ZippingIterator<E> zippingIterator(Iterator<? extends E> a, Iterator<? extends E> b) {
        return new ZippingIterator<E>(a, b);
    }

    public static <E> ZippingIterator<E> zippingIterator(Iterator<? extends E> a, Iterator<? extends E> b, Iterator<? extends E> c) {
        return new ZippingIterator<E>(a, b, c);
    }

    private IteratorUtils() {
    }
}

