/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.primitive.BooleanLists;
import org.eclipse.collections.api.factory.primitive.ByteLists;
import org.eclipse.collections.api.factory.primitive.CharLists;
import org.eclipse.collections.api.factory.primitive.DoubleLists;
import org.eclipse.collections.api.factory.primitive.FloatLists;
import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.factory.primitive.LongLists;
import org.eclipse.collections.api.factory.primitive.ShortLists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.UnsortedMapIterable;
import org.eclipse.collections.api.map.sorted.SortedMapIterable;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.multimap.sortedset.MutableSortedSetMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.CollectProcedure;
import org.eclipse.collections.impl.block.procedure.CollectionAddProcedure;
import org.eclipse.collections.impl.block.procedure.CountProcedure;
import org.eclipse.collections.impl.block.procedure.MapEntryToProcedure2;
import org.eclipse.collections.impl.block.procedure.MapPutProcedure;
import org.eclipse.collections.impl.block.procedure.RejectProcedure;
import org.eclipse.collections.impl.block.procedure.SelectProcedure;
import org.eclipse.collections.impl.factory.Multimaps;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.MapAdapter;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.set.sorted.TreeSortedSetMultimap;
import org.eclipse.collections.impl.tuple.AbstractImmutableEntry;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public final class MapIterate {
    private MapIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean notEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static <K, V> V getIfAbsentPut(Map<K, V> map, K key, Function0<? extends V> instanceBlock) {
        if (map instanceof MutableMap) {
            return (V)((MutableMap)map).getIfAbsentPut(key, instanceBlock);
        }
        V result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = instanceBlock.value();
            map.put(key, result);
        }
        return result;
    }

    public static <K, V, P> V getIfAbsentPutWith(Map<K, V> map, K key, Function<? super P, ? extends V> function, P parameter) {
        V result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = function.valueOf(parameter);
            map.put(key, result);
        }
        return result;
    }

    public static <K, V> V getIfAbsent(Map<K, V> map, K key, Function0<? extends V> instanceBlock) {
        if (map instanceof UnsortedMapIterable) {
            return ((MapIterable)((Object)map)).getIfAbsent(key, instanceBlock);
        }
        V result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = instanceBlock.value();
        }
        return result;
    }

    public static <K, V, P> V getIfAbsentWith(Map<K, V> map, K key, Function<? super P, ? extends V> function, P parameter) {
        if (map instanceof UnsortedMapIterable) {
            return ((MapIterable)((Object)map)).getIfAbsentWith(key, function, parameter);
        }
        V result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = function.valueOf(parameter);
        }
        return result;
    }

    public static <K, V> V getIfAbsentDefault(Map<K, V> map, K key, V defaultValue) {
        V result = map.get(key);
        if (MapIterate.isAbsent(result, map, key)) {
            result = defaultValue;
        }
        return result;
    }

    private static <K, V> boolean isAbsent(V result, Map<K, V> map, K key) {
        return result == null && !map.containsKey(key);
    }

    public static <K, V, A> A ifPresentApply(Map<K, V> map, K key, Function<? super V, ? extends A> function) {
        if (map instanceof UnsortedMapIterable) {
            return ((MapIterable)((Object)map)).ifPresentApply(key, function);
        }
        V result = map.get(key);
        return MapIterate.isAbsent(result, map, key) ? null : (A)function.valueOf((V)result);
    }

    public static <K, V> MutableList<V> select(Map<K, V> map, Predicate<? super V> predicate) {
        return MapIterate.select(map, predicate, FastList.newList());
    }

    public static <K, V, R extends Collection<V>> R select(Map<K, V> map, Predicate<? super V> predicate, R targetCollection) {
        SelectProcedure<? super V> procedure = new SelectProcedure<V>(predicate, targetCollection);
        MapIterate.forEachValue(map, procedure);
        return targetCollection;
    }

    public static <K, V> int count(Map<K, V> map, Predicate<? super V> predicate) {
        CountProcedure<V> procedure = new CountProcedure<V>(predicate);
        MapIterate.forEachValue(map, procedure);
        return procedure.getCount();
    }

    public static <K, V> MutableMap<K, V> selectMapOnEntry(Map<K, V> map, Predicate2<? super K, ? super V> predicate) {
        return MapIterate.selectMapOnEntry(map, predicate, Maps.mutable.empty());
    }

    public static <K, V, R extends Map<K, V>> R selectMapOnEntry(Map<K, V> map, Predicate2<? super K, ? super V> predicate, R target) {
        MapPutProcedure mapTransferProcedure = new MapPutProcedure(target);
        Procedure2<Object, Object> procedure = (key, value) -> {
            if (predicate.accept((Object)key, (Object)value)) {
                mapTransferProcedure.value(key, value);
            }
        };
        MapIterate.forEachKeyValue(map, procedure);
        return target;
    }

    public static <K, V> MutableMap<K, V> selectMapOnKey(Map<K, V> map, Predicate<? super K> predicate) {
        MutableMap resultMap = Maps.mutable.empty();
        MapPutProcedure mapTransferProcedure = new MapPutProcedure(resultMap);
        Procedure2<Object, Object> procedure = (key, value) -> {
            if (predicate.accept((Object)key)) {
                mapTransferProcedure.value(key, value);
            }
        };
        MapIterate.forEachKeyValue(map, procedure);
        return resultMap;
    }

    public static <K, V> MutableMap<K, V> selectMapOnValue(Map<K, V> map, Predicate<? super V> predicate) {
        MutableMap resultMap = Maps.mutable.empty();
        MapPutProcedure mapTransferProcedure = new MapPutProcedure(resultMap);
        Procedure2<Object, Object> procedure = (key, value) -> {
            if (predicate.accept((Object)value)) {
                mapTransferProcedure.value(key, value);
            }
        };
        MapIterate.forEachKeyValue(map, procedure);
        return resultMap;
    }

    public static <K, V> MutableList<V> reject(Map<K, V> map, Predicate<? super V> predicate) {
        return MapIterate.reject(map, predicate, FastList.newList());
    }

    public static <K, V, R extends Collection<V>> R reject(Map<K, V> map, Predicate<? super V> predicate, R targetCollection) {
        RejectProcedure<? super V> procedure = new RejectProcedure<V>(predicate, targetCollection);
        MapIterate.forEachValue(map, procedure);
        return targetCollection;
    }

    public static <K, V> MutableMap<K, V> rejectMapOnEntry(Map<K, V> map, Predicate2<? super K, ? super V> predicate) {
        return MapIterate.rejectMapOnEntry(map, predicate, Maps.mutable.empty());
    }

    public static <K, V, R extends Map<K, V>> R rejectMapOnEntry(Map<K, V> map, Predicate2<? super K, ? super V> predicate, R target) {
        MapIterate.forEachKeyValue(map, (argument1, argument2) -> {
            if (!predicate.accept((Object)argument1, (Object)argument2)) {
                target.put(argument1, argument2);
            }
        });
        return target;
    }

    public static <K, V> Collection<K> addAllKeysTo(Map<K, V> map, Collection<K> targetCollection) {
        MapIterate.forEachKey(map, CollectionAddProcedure.on(targetCollection));
        return targetCollection;
    }

    public static <K, V> Collection<V> addAllValuesTo(Map<K, V> map, Collection<V> targetCollection) {
        MapIterate.forEachValue(map, CollectionAddProcedure.on(targetCollection));
        return targetCollection;
    }

    public static <K, V, A> MutableList<A> collect(Map<K, V> map, Function<? super V, ? extends A> function) {
        return MapIterate.collect(map, function, Lists.mutable.withInitialCapacity(map.size()));
    }

    public static <K, V> MutableBooleanCollection collectBoolean(Map<K, V> map, BooleanFunction<? super V> booleanFunction) {
        return MapIterate.collectBoolean(map, booleanFunction, BooleanLists.mutable.withInitialCapacity(map.size()));
    }

    public static <K, V, R extends MutableBooleanCollection> R collectBoolean(Map<K, V> map, BooleanFunction<? super V> booleanFunction, R target) {
        MapIterate.forEachValue(map, each -> target.add(booleanFunction.booleanValueOf((Object)each)));
        return target;
    }

    public static <K, V> MutableByteCollection collectByte(Map<K, V> map, ByteFunction<? super V> byteFunction) {
        return MapIterate.collectByte(map, byteFunction, ByteLists.mutable.withInitialCapacity(map.size()));
    }

    public static <K, V, R extends MutableByteCollection> R collectByte(Map<K, V> map, ByteFunction<? super V> byteFunction, R target) {
        MapIterate.forEachValue(map, each -> target.add(byteFunction.byteValueOf((Object)each)));
        return target;
    }

    public static <K, V> MutableCharCollection collectChar(Map<K, V> map, CharFunction<? super V> charFunction) {
        return MapIterate.collectChar(map, charFunction, CharLists.mutable.withInitialCapacity(map.size()));
    }

    public static <K, V, R extends MutableCharCollection> R collectChar(Map<K, V> map, CharFunction<? super V> charFunction, R target) {
        MapIterate.forEachValue(map, each -> target.add(charFunction.charValueOf((Object)each)));
        return target;
    }

    public static <K, V> MutableDoubleCollection collectDouble(Map<K, V> map, DoubleFunction<? super V> doubleFunction) {
        return MapIterate.collectDouble(map, doubleFunction, DoubleLists.mutable.withInitialCapacity(map.size()));
    }

    public static <K, V, R extends MutableDoubleCollection> R collectDouble(Map<K, V> map, DoubleFunction<? super V> doubleFunction, R target) {
        MapIterate.forEachValue(map, each -> target.add(doubleFunction.doubleValueOf((Object)each)));
        return target;
    }

    public static <K, V> MutableFloatCollection collectFloat(Map<K, V> map, FloatFunction<? super V> floatFunction) {
        return MapIterate.collectFloat(map, floatFunction, FloatLists.mutable.withInitialCapacity(map.size()));
    }

    public static <K, V, R extends MutableFloatCollection> R collectFloat(Map<K, V> map, FloatFunction<? super V> floatFunction, R target) {
        MapIterate.forEachValue(map, each -> target.add(floatFunction.floatValueOf((Object)each)));
        return target;
    }

    public static <K, V> MutableIntCollection collectInt(Map<K, V> map, IntFunction<? super V> intFunction) {
        return MapIterate.collectInt(map, intFunction, IntLists.mutable.withInitialCapacity(map.size()));
    }

    public static <K, V, R extends MutableIntCollection> R collectInt(Map<K, V> map, IntFunction<? super V> intFunction, R target) {
        MapIterate.forEachValue(map, each -> target.add(intFunction.intValueOf((Object)each)));
        return target;
    }

    public static <K, V> MutableLongCollection collectLong(Map<K, V> map, LongFunction<? super V> longFunction) {
        return MapIterate.collectLong(map, longFunction, LongLists.mutable.withInitialCapacity(map.size()));
    }

    public static <K, V, R extends MutableLongCollection> R collectLong(Map<K, V> map, LongFunction<? super V> longFunction, R target) {
        MapIterate.forEachValue(map, each -> target.add(longFunction.longValueOf((Object)each)));
        return target;
    }

    public static <K, V> MutableShortCollection collectShort(Map<K, V> map, ShortFunction<? super V> shortFunction) {
        return MapIterate.collectShort(map, shortFunction, ShortLists.mutable.withInitialCapacity(map.size()));
    }

    public static <K, V, R extends MutableShortCollection> R collectShort(Map<K, V> map, ShortFunction<? super V> shortFunction, R target) {
        MapIterate.forEachValue(map, each -> target.add(shortFunction.shortValueOf((Object)each)));
        return target;
    }

    public static <K, V, K2, V2> MutableMap<K2, V2> collect(Map<K, V> map, Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return MapIterate.collect(map, function, UnifiedMap.newMap(map.size()));
    }

    public static <K1, V1, K2, V2, R extends Map<K2, V2>> R collect(Map<K1, V1> map, Function2<? super K1, ? super V1, Pair<K2, V2>> function, R target) {
        MapIterate.forEachKeyValue(map, (key, value) -> {
            Pair pair = (Pair)function.value((Object)key, (Object)value);
            target.put(pair.getOne(), pair.getTwo());
        });
        return target;
    }

    public static <K, V, V2> MutableMap<K, V2> collectValues(Map<K, V> map, Function2<? super K, ? super V, ? extends V2> function) {
        return MapIterate.collectValues(map, function, UnifiedMap.newMap(map.size()));
    }

    public static <K, V, V2, R extends Map<K, V2>> R collectValues(Map<K, V> map, Function2<? super K, ? super V, ? extends V2> function, R target) {
        MapIterate.forEachKeyValue(map, (key, value) -> target.put(key, function.value((Object)key, (Object)value)));
        return target;
    }

    public static <K, V, K2, R extends Map<K2, V>> R collectKeysUnique(Map<K, V> map, Function2<? super K, ? super V, ? extends K2> function, R target) {
        MapIterate.forEachKeyValue(map, (key, value) -> {
            Object newKey = function.value((Object)key, (Object)value);
            Object previousValue = target.put(newKey, value);
            if (previousValue != null) {
                throw new IllegalStateException("Key " + newKey + " already exists in map!");
            }
        });
        return target;
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collectIf(Map<K1, V1> map, Function2<? super K1, ? super V1, Pair<K2, V2>> function, Predicate2<? super K1, ? super V1> predicate) {
        return MapIterate.collectIf(map, function, predicate, Maps.mutable.empty());
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collectIf(Map<K1, V1> map, Function2<? super K1, ? super V1, Pair<K2, V2>> function, Predicate2<? super K1, ? super V1> predicate, Map<K2, V2> target) {
        MutableMap result = MapAdapter.adapt(target);
        MapIterate.forEachKeyValue(map, (key, value) -> {
            if (predicate.accept((Object)key, (Object)value)) {
                Pair pair = (Pair)function.value((Object)key, (Object)value);
                result.put(pair.getOne(), pair.getTwo());
            }
        });
        return result;
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collect(Map<K1, V1> map, Function<? super K1, ? extends K2> keyFunction, Function<? super V1, ? extends V2> valueFunction) {
        return MapIterate.collect(map, keyFunction, valueFunction, Maps.mutable.empty());
    }

    public static <K1, V1, K2, V2> MutableMap<K2, V2> collect(Map<K1, V1> map, Function<? super K1, ? extends K2> keyFunction, Function<? super V1, ? extends V2> valueFunction, Map<K2, V2> target) {
        return MapIterate.collect(map, (? super K1 key, ? super V1 value) -> Tuples.pair(keyFunction.valueOf((Object)key), valueFunction.valueOf((Object)value)), MapAdapter.adapt(target));
    }

    public static <K, V, A, R extends Collection<A>> R collect(Map<K, V> map, Function<? super V, ? extends A> function, R targetCollection) {
        CollectProcedure<? super V, ? extends A> procedure = new CollectProcedure<V, A>(function, targetCollection);
        MapIterate.forEachValue(map, procedure);
        return targetCollection;
    }

    public static <K, V> void forEachValue(Map<K, V> map, Procedure<? super V> procedure) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot perform a forEachValue on null");
        }
        if (MapIterate.notEmpty(map)) {
            if (map instanceof UnsortedMapIterable) {
                ((MapIterable)((Object)map)).forEachValue(procedure);
            } else {
                IterableIterate.forEach(map.values(), procedure);
            }
        }
    }

    public static <K, V> void forEachKey(Map<K, V> map, Procedure<? super K> procedure) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot perform a forEachKey on null");
        }
        if (MapIterate.notEmpty(map)) {
            if (map instanceof UnsortedMapIterable) {
                ((MapIterable)((Object)map)).forEachKey(procedure);
            } else {
                IterableIterate.forEach(map.keySet(), procedure);
            }
        }
    }

    public static <K, V> void forEachKeyValue(Map<K, V> map, Procedure2<? super K, ? super V> procedure) {
        Objects.requireNonNull(map, "Cannot perform a forEachKeyValue on null");
        if (MapIterate.notEmpty(map)) {
            if (map instanceof UnsortedMapIterable) {
                ((MapIterable)((Object)map)).forEachKeyValue(procedure);
            } else {
                IterableIterate.forEach(map.entrySet(), new MapEntryToProcedure2<K, V>(procedure));
            }
        }
    }

    public static <K, V> MutableMap<V, K> flipUniqueValues(MapIterable<K, V> mapIterable) {
        MutableMap result = Maps.mutable.empty();
        mapIterable.forEachKeyValue((key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result;
    }

    public static <K, V> Pair<K, V> detect(Map<K, V> map, Predicate2<? super K, ? super V> predicate) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot perform a detect on null");
        }
        if (map instanceof ImmutableMap || map instanceof MutableMap) {
            RichIterable entries2 = map instanceof ImmutableMap ? ((ImmutableMap)((Object)map)).keyValuesView() : LazyIterate.adapt(map.entrySet()).collect(AbstractImmutableEntry.getPairFunction());
            return entries2.detect(each -> predicate.accept(each.getOne(), each.getTwo()));
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!predicate.accept(entry.getKey(), entry.getValue())) continue;
            return Tuples.pairFrom(entry);
        }
        return null;
    }

    public static <K, V> V detect(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.detect(map.values(), predicate);
    }

    public static <K, V> Optional<Pair<K, V>> detectOptional(Map<K, V> map, Predicate2<? super K, ? super V> predicate) {
        return Optional.ofNullable(MapIterate.detect(map, predicate));
    }

    public static <K, V> Optional<V> detectOptional(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.detectOptional(map.values(), predicate);
    }

    public static <K, V> V detectIfNone(Map<K, V> map, Predicate<? super V> predicate, V ifNone) {
        return Iterate.detectIfNone(map.values(), predicate, ifNone);
    }

    public static <K, V, IV> IV injectInto(IV injectValue, Map<K, V> map, Function2<? super IV, ? super V, ? extends IV> function) {
        return Iterate.injectInto(injectValue, map.values(), function);
    }

    public static <IV, K, V> IV injectIntoIf(IV initialValue, Map<K, V> map, Predicate<? super V> predicate, Function2<? super IV, ? super V, ? extends IV> function) {
        Function2<Object, Object, Object> ifFunction = (accumulator, item) -> {
            if (predicate.accept((Object)item)) {
                return function.value((Object)accumulator, (Object)item);
            }
            return accumulator;
        };
        return (IV)Iterate.injectInto(initialValue, map.values(), ifFunction);
    }

    public static <K, V> boolean anySatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.anySatisfy(map.values(), predicate);
    }

    public static <K, V> boolean allSatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.allSatisfy(map.values(), predicate);
    }

    public static <K, V> boolean noneSatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        return IterableIterate.noneSatisfy(map.values(), predicate);
    }

    public static <K, V> MutableList<Pair<K, V>> toListOfPairs(Map<K, V> map) {
        MutableList pairs = Lists.mutable.withInitialCapacity(map.size());
        MapIterate.forEachKeyValue(map, (key, value) -> pairs.add(Tuples.pair(key, value)));
        return pairs;
    }

    public static <K, V> MutableList<V> toSortedList(Map<K, V> map, Comparator<? super V> comparator) {
        return Iterate.toSortedList(map.values(), comparator);
    }

    public static <K, V> MutableMap<V, K> reverseMapping(Map<K, V> map) {
        UnifiedMap reverseMap = UnifiedMap.newMap(map.size());
        MapIterate.forEachKeyValue(map, (sourceKey, sourceValue) -> reverseMap.put(sourceValue, sourceKey));
        return reverseMap;
    }

    public static <K, V> int occurrencesOf(Map<K, V> map, V object) {
        return Iterate.count(map.values(), Predicates.equal(object));
    }

    public static <K, V, A> int occurrencesOfAttribute(Map<K, V> map, Function<? super V, ? extends A> function, A object) {
        return Iterate.count(map.values(), Predicates.attributeEqual(function, object));
    }

    public static <K, V> MutableSetMultimap<V, K> flip(MapIterable<K, V> iMap) {
        MutableSetMultimap result = Multimaps.mutable.set.with();
        iMap.forEachKeyValue((key, val) -> result.put(val, key));
        return result;
    }

    public static <K, V> MutableSortedSetMultimap<V, K> flip(SortedMapIterable<K, V> iMap) {
        TreeSortedSetMultimap result = new TreeSortedSetMultimap(iMap.comparator());
        iMap.forEachKeyValue((key, val) -> result.put(val, key));
        return result;
    }
}

