/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import org.reactfx.Subscription;

public class SubscribeableContentsObsSet<E>
extends AbstractSet<E>
implements ObservableSet<E> {
    private final List<Function<? super E, Subscription>> subscribers = new LinkedList<Function<? super E, Subscription>>();
    private final List<SetChangeListener<? super E>> changeListeners = new LinkedList<SetChangeListener<? super E>>();
    private final List<InvalidationListener> invalidationListeners = new LinkedList<InvalidationListener>();
    private final Map<E, List<Subscription>> map;

    public SubscribeableContentsObsSet() {
        this(null);
    }

    public SubscribeableContentsObsSet(Comparator<? super E> comparator) {
        this.map = new TreeMap<E, List<Subscription>>(comparator);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean add(E e) {
        Objects.requireNonNull(e, "Cannot add a null object to this list");
        if (this.map.containsKey(e)) {
            return false;
        }
        ArrayList list = new ArrayList(1);
        this.subscribers.stream().map(f -> (Subscription)f.apply(e)).forEach(list::add);
        this.map.put(e, list);
        this.invalidateSet();
        this.fireElementAdded(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        List<Subscription> list = this.map.remove(o);
        if (list == null) {
            return false;
        }
        list.forEach(Subscription::unsubscribe);
        this.invalidateSet();
        this.fireElementRemoved(o);
        return true;
    }

    public Subscription addSubscriber(Function<? super E, Subscription> subscriber) {
        Objects.requireNonNull(subscriber);
        this.subscribers.add(subscriber);
        ArrayList<E> keys2 = new ArrayList<E>(this.map.keySet());
        keys2.forEach(key -> {
            List<Subscription> otherSubs = this.map.get(key);
            Subscription sub = (Subscription)subscriber.apply((E)key);
            otherSubs.add(sub);
            this.map.put(key, otherSubs);
        });
        return () -> this.removeSubscriber(subscriber);
    }

    public Subscription addChangeListener(SetChangeListener<? super E> listener) {
        this.addListener(listener);
        return () -> this.removeListener(listener);
    }

    public Subscription addInvalidationListener(InvalidationListener listener) {
        this.addListener(listener);
        return () -> this.removeListener(listener);
    }

    @Override
    public void addListener(SetChangeListener<? super E> listener) {
        this.changeListeners.add(listener);
    }

    @Override
    public void removeListener(SetChangeListener<? super E> listener) {
        this.changeListeners.remove(listener);
    }

    @Override
    public void addListener(InvalidationListener listener) {
        this.invalidationListeners.add(listener);
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        this.invalidationListeners.remove(listener);
    }

    private void invalidateSet() {
        this.invalidationListeners.forEach(l -> l.invalidated(this));
    }

    private void removeSubscriber(Function<? super E, Subscription> subscriber) {
        int index = -1;
        int i = 0;
        Iterator<Function<E, Subscription>> iter = this.subscribers.iterator();
        while (iter.hasNext() && index == -1) {
            Function<? super E, Subscription> s = iter.next();
            if (s == subscriber) {
                iter.remove();
                index = i;
                continue;
            }
            ++i;
        }
        int finalIndex = index;
        ArrayList<E> keys2 = new ArrayList<E>(this.map.keySet());
        keys2.forEach(key -> this.map.get(key).remove(finalIndex).unsubscribe());
    }

    private void fireElementAdded(final E elem) {
        SetChangeListener.Change change = new SetChangeListener.Change<E>(this){

            @Override
            public boolean wasAdded() {
                return true;
            }

            @Override
            public boolean wasRemoved() {
                return false;
            }

            @Override
            public E getElementAdded() {
                return elem;
            }

            @Override
            public E getElementRemoved() {
                return null;
            }
        };
        this.changeListeners.forEach(l -> l.onChanged(change));
    }

    private void fireElementRemoved(final E elem) {
        SetChangeListener.Change change = new SetChangeListener.Change<E>(this){

            @Override
            public boolean wasAdded() {
                return false;
            }

            @Override
            public boolean wasRemoved() {
                return true;
            }

            @Override
            public E getElementAdded() {
                return null;
            }

            @Override
            public E getElementRemoved() {
                return elem;
            }
        };
        this.changeListeners.forEach(l -> l.onChanged(change));
    }
}

