/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.GroupSerializer;

public abstract class SerializerFourByte<E>
implements GroupSerializer<E> {
    protected abstract E unpack(int var1);

    protected abstract int pack(E var1);

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public int fixedSize() {
        return 4;
    }

    @Override
    public E valueArrayGet(Object vals, int pos) {
        return this.unpack(((int[])vals)[pos]);
    }

    @Override
    public int valueArraySize(Object vals) {
        return ((int[])vals).length;
    }

    @Override
    public Object valueArrayEmpty() {
        return new int[0];
    }

    @Override
    public Object valueArrayPut(Object vals, int pos, E newValue) {
        int[] array = (int[])vals;
        int[] ret = Arrays.copyOf(array, array.length + 1);
        if (pos < array.length) {
            System.arraycopy(array, pos, ret, pos + 1, array.length - pos);
        }
        ret[pos] = this.pack(newValue);
        return ret;
    }

    @Override
    public Object valueArrayUpdateVal(Object vals, int pos, E newValue) {
        int[] vals2 = (int[])((int[])vals).clone();
        vals2[pos] = this.pack(newValue);
        return vals2;
    }

    @Override
    public Object valueArrayFromArray(Object[] objects) {
        int[] ret = new int[objects.length];
        int pos = 0;
        for (Object o : objects) {
            ret[pos++] = this.pack(o);
        }
        return ret;
    }

    @Override
    public Object valueArrayCopyOfRange(Object vals, int from, int to) {
        return Arrays.copyOfRange((int[])vals, from, to);
    }

    @Override
    public Object valueArrayDeleteValue(Object vals, int pos) {
        int[] valsOrig = (int[])vals;
        int[] vals2 = new int[valsOrig.length - 1];
        System.arraycopy(vals, 0, vals2, 0, pos - 1);
        System.arraycopy(vals, pos, vals2, pos - 1, vals2.length - (pos - 1));
        return vals2;
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        for (int o : (int[])vals) {
            out.writeInt(o);
        }
    }

    @Override
    public Object valueArrayDeserialize(DataInput2 in, int size) throws IOException {
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = in.readInt();
        }
        return ret;
    }

    @Override
    public final int valueArraySearch(Object keys2, E key, Comparator comparator) {
        if (comparator == this) {
            return this.valueArraySearch(keys2, key);
        }
        int[] array = (int[])keys2;
        int lo = 0;
        int hi = array.length - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int compare = comparator.compare(key, this.unpack(array[mid]));
            if (compare == 0) {
                return mid;
            }
            if (compare < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -(lo + 1);
    }

    @Override
    public E valueArrayBinaryGet(DataInput2 input, int keysLen, int pos) throws IOException {
        input.skipBytes(pos * 4);
        return this.unpack(input.readInt());
    }
}

