/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.SerializerEightByte;

public class SerializerLong
extends SerializerEightByte<Long> {
    @Override
    public void serialize(DataOutput2 out, Long value) throws IOException {
        out.writeLong(value);
    }

    @Override
    public Long deserialize(DataInput2 in, int available) throws IOException {
        return new Long(in.readLong());
    }

    @Override
    protected Long unpack(long l) {
        return new Long(l);
    }

    @Override
    protected long pack(Long l) {
        return l;
    }

    @Override
    public int valueArraySearch(Object keys2, Long key) {
        return Arrays.binarySearch((long[])keys2, key);
    }

    @Override
    public int valueArrayBinarySearch(Long key, DataInput2 input, int keysLen, Comparator comparator) throws IOException {
        if (comparator != this) {
            return super.valueArrayBinarySearch(key, input, keysLen, comparator);
        }
        long key2 = key;
        for (int pos = 0; pos < keysLen; ++pos) {
            long from = input.readLong();
            if (key2 > from) continue;
            input.skipBytes((keysLen - pos - 1) * 8);
            return key2 == from ? pos : -(pos + 1);
        }
        return -(keysLen + 1);
    }
}

