/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.AbstractComXervService;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.ExchangeSpecific;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.BasketRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.service.StatusMessageService;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSubmitter;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.SentOrders;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.trading.api.Request;
import com.deutscheboerse.m7.trading.api.v6.ErrResp;
import com.deutscheboerse.m7.trading.api.v6.ErrorType;
import com.deutscheboerse.m7.trading.api.v6.ListExecInstType;
import com.deutscheboerse.m7.trading.api.v6.ModifyAllOrdrs;
import com.deutscheboerse.m7.trading.api.v6.OrdrEntry;
import com.deutscheboerse.m7.trading.api.v6.OrdrEntryType;
import com.deutscheboerse.m7.trading.api.v6.OrdrExeRprt;
import com.deutscheboerse.m7.trading.api.v6.OrdrListEntryType;
import com.deutscheboerse.m7.trading.api.v6.OrdrModificationType;
import com.deutscheboerse.m7.trading.api.v6.OrdrModify;
import com.deutscheboerse.m7.trading.api.v6.OrdrType;
import com.deutscheboerse.m7.trading.api.v6.PblcOrdrBooksDeltaRprt;
import com.deutscheboerse.m7.trading.api.v6.StandardHeaderType;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ExchangeSpecific(apiVersion="v6")
public class ComXervOrderSubmitter
extends AbstractComXervService
implements OrderSubmitter {
    private static final Logger LOG = LoggerFactory.getLogger(ComXervOrderSubmitter.class);
    private final UserService userService;
    private final StatusMessageService statusMessageService;

    @Inject
    public ComXervOrderSubmitter(ApplicationContext applicationContext) {
        super(applicationContext);
        this.userService = applicationContext.getService(UserService.class);
        this.statusMessageService = applicationContext.getService(StatusMessageService.class);
    }

    @Override
    public ListMultimap<Request, Order> createOrderRequests(List<Order> orders, RequestType requestType, BasketRestriction basketRestriction, User onBehalfUser) {
        MapperHandler mapper = this.getMapper();
        ArrayListMultimap<Request, Order> requests = ArrayListMultimap.create();
        StandardHeaderType standardHeader = this.getStandardHeader(onBehalfUser);
        int maxOrders = this.getSession().getExchange().getSystemInfo().getMaxOrders();
        int requestsNeeded = orders.size() / maxOrders + (orders.size() % maxOrders == 0 ? 0 : 1);
        switch (requestType) {
            case ACTIVATE: 
            case DELETE: 
            case DEACTIVATE: 
            case MODIFY: {
                for (int i = 0; i < requestsNeeded; ++i) {
                    OrdrModify request = this.createNewOrdrModify(standardHeader, requestType);
                    int fromIndex = i * maxOrders;
                    int toIndex = (i + 1) * maxOrders;
                    List<Order> requestOrders = orders.subList(fromIndex, toIndex < orders.size() ? toIndex : orders.size());
                    for (Order requestOrder : requestOrders) {
                        request.getOrdrList().getOrdr().add(mapper.translate(OrdrModificationType.class, requestOrder));
                    }
                    requests.putAll(request, requestOrders);
                }
                break;
            }
            case ADD: {
                ListExecInstType listExecInst = basketRestriction != null ? mapper.translate(ListExecInstType.class, basketRestriction) : null;
                for (int i = 0; i < requestsNeeded; ++i) {
                    OrdrEntry request = this.createNewOrderEntry(standardHeader, listExecInst);
                    int fromIndex = i * maxOrders;
                    int toIndex = (i + 1) * maxOrders;
                    List<Order> requestOrders = orders.subList(fromIndex, toIndex < orders.size() ? toIndex : orders.size());
                    for (Order requestOrder : requestOrders) {
                        request.getOrdrList().getOrdr().add(mapper.translate(OrdrEntryType.class, requestOrder));
                    }
                    requests.putAll(request, requestOrders);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal request type " + requestType.getDisplayName());
            }
        }
        return requests;
    }

    private OrdrModify createNewOrdrModify(StandardHeaderType standardHeader, RequestType requestType) {
        OrdrModify ordrModify = new OrdrModify();
        ordrModify.setStandardHeader(standardHeader);
        ordrModify.setOrdrList(new OrdrModify.OrdrList());
        ordrModify.setOrdrModType(EnumMapper.mapRequestType(requestType));
        return ordrModify;
    }

    private OrdrEntry createNewOrderEntry(StandardHeaderType standardHeader, ListExecInstType listExecInst) {
        OrdrEntry ordrEntry = new OrdrEntry();
        ordrEntry.setListExecInst(listExecInst);
        ordrEntry.setStandardHeader(standardHeader);
        ordrEntry.setOrdrList(new OrdrEntry.OrdrList());
        return ordrEntry;
    }

    @Override
    public Request createEmergencyOrderRequest(RequestType requestType, boolean considerOnBehalf) {
        ModifyAllOrdrs request = new ModifyAllOrdrs();
        switch (requestType) {
            case ACTIVATE: 
            case DELETE: 
            case DEACTIVATE: {
                StandardHeaderType standardHeader = this.getStandardHeader(considerOnBehalf);
                request.setStandardHeader(standardHeader);
                request.setUsrId((Integer)this.userService.getCurrentUser().getId());
                request.setOrdrModType(EnumMapper.mapBatchRequestType(requestType));
                request.setInclPreArranged(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal request type " + requestType.getDisplayName());
            }
        }
        return request;
    }

    @Override
    public boolean processAsyncServerResponse(Object object, SentOrders sentOrders) {
        BasketRestriction basketRestriction = sentOrders.getBasketRestriction();
        if (object instanceof ErrResp) {
            return this.processAsyncErrorResp((ErrResp)object, sentOrders);
        }
        if (basketRestriction == BasketRestriction.LNK && object instanceof OrdrExeRprt) {
            return this.handleAsyncLinkedOrdrExeRprt((OrdrExeRprt)object, sentOrders);
        }
        if (object instanceof OrdrExeRprt) {
            return this.handleOrdrExeRprt((OrdrExeRprt)object, sentOrders);
        }
        return true;
    }

    private boolean handleOrdrExeRprt(OrdrExeRprt object, SentOrders sentOrders) {
        for (OrdrListEntryType ordr : object.getOrdrList().getOrdr()) {
            sentOrders.getResponseHandler().handleResponse(new AsyncResponse(ResponseStatus.SUCCESS, ordr.getClOrdrId()));
            if (ordr.getClOrdrId() == null) continue;
            OrderType orderType = sentOrders.getSentOrderType(ordr.getClOrdrId());
            if (orderType == OrderType.STOP && ordr.getType() == OrdrType.O) {
                this.statusMessageService.stopOrderConverted(ordr.getClOrdrId());
            }
            sentOrders.getClientOrderIds().remove(ordr.getClOrdrId());
        }
        return !sentOrders.getClientOrderIds().isEmpty();
    }

    private boolean handleAsyncLinkedOrdrExeRprt(OrdrExeRprt ordrExeRprt, SentOrders sentOrders) {
        ResponseHandler responseHandler = sentOrders.getResponseHandler();
        Set<String> clientOrderIds = sentOrders.getClientOrderIds();
        if (ordrExeRprt.getOrdrList() != null && !ordrExeRprt.getOrdrList().getOrdr().isEmpty()) {
            if (ordrExeRprt.getOrdrList().getOrdr().stream().map(OrdrListEntryType::getAction).anyMatch("SDEL"::equals)) {
                sentOrders.getClientOrderIds().clear();
                responseHandler.handleResponse(new AsyncResponse(ResponseStatus.ERROR, null, Util.getLabel("basketPanel_linkedOrdersNotMatched"), com.deutscheboerse.comxerv.comtrader.service.async.ErrorType.LINKED_BASKET_NOT_MATCHED));
                return false;
            }
            for (OrdrListEntryType ordr : ordrExeRprt.getOrdrList().getOrdr()) {
                String clientOrderId = ordr.getClOrdrId();
                if (clientOrderId == null) continue;
                responseHandler.handleResponse(new AsyncResponse(ResponseStatus.SUCCESS, clientOrderId));
                clientOrderIds.remove(clientOrderId);
            }
            return !clientOrderIds.isEmpty();
        }
        LOG.error("Received empty/invalid order execution report from server.");
        responseHandler.handleGeneralError();
        return false;
    }

    private boolean processAsyncErrorResp(ErrResp errorResp, SentOrders sentOrders) {
        this.handleErrors(errorResp.getError().stream(), sentOrders.getResponseHandler());
        if (sentOrders.getBasketRestriction() == BasketRestriction.VLD) {
            sentOrders.getClientOrderIds().clear();
            sentOrders.getResponseHandler().handleResponse(new AsyncResponse(ResponseStatus.ERROR, null, Util.getLabel("basketPanel_invalidOrders"), com.deutscheboerse.comxerv.comtrader.service.async.ErrorType.BASKET_NOT_VALID));
            return false;
        }
        Set<String> clientOrderIds = sentOrders.getClientOrderIds();
        errorResp.getError().stream().map(ErrorType::getClOrdrId).filter(Objects::nonNull).forEach(clientOrderIds::remove);
        return !clientOrderIds.isEmpty();
    }

    @Override
    public boolean isOrderbookUpdateBroadcastOrError(Object broadcast) {
        return broadcast instanceof PblcOrdrBooksDeltaRprt || broadcast instanceof ErrResp;
    }
}

