/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.AbstractTextWithVarsMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.m7.trading.api.v6.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorTypeMapper
extends AbstractTextWithVarsMapper<ErrorType, AsyncResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorTypeMapper.class);

    public ErrorTypeMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, ErrorType.class, AsyncResponse.class);
    }

    @Override
    public AsyncResponse translate(ErrorType from, MapperHandler mapperHandler, Object hint) {
        String errorText;
        com.deutscheboerse.comxerv.comtrader.service.async.ErrorType errorType = mapperHandler.translate(com.deutscheboerse.comxerv.comtrader.service.async.ErrorType.class, from.getErrCode());
        try {
            errorText = this.getMessageFormatter().formatError(from.getErrCode(), this.mapVars(from.getVarList()));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unknown error code: {}, using untranslated text as fallback: {}.", (Object)from.getErrCode(), (Object)from.getErr());
            errorText = from.getErr();
        }
        return new AsyncResponse(ResponseStatus.ERROR, from.getClOrdrId(), errorText, errorType);
    }
}

