/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.OrderLimit;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.m7.trading.api.v6.MbrVolumeType;
import com.deutscheboerse.m7.trading.api.v6.OrdrLmtType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderLimitMapper
extends AbstractMapper<OrdrLmtType, OrderLimit> {
    private static final Logger LOG = LoggerFactory.getLogger(OrderLimitMapper.class);

    public OrderLimitMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, OrdrLmtType.class, OrderLimit.class);
    }

    @Override
    public OrderLimit translate(OrdrLmtType from, MapperHandler mapperHandler, Object hint) {
        MbrVolumeType mbrVolumeType = (MbrVolumeType)hint;
        OrderLimit orderLimit = new OrderLimit();
        orderLimit.setId(from.getLmtId());
        orderLimit.setRevisionNumber(from.getRevisionNo());
        orderLimit.setMemberCode(mbrVolumeType.getMbrId());
        Product product = this.applicationContext.getDataModel(Product.class).findById(from.getProdName());
        if (product == null) {
            LOG.error("The orderLimit {} has unknown product {}", (Object)from.getLmtId(), (Object)from.getProdName());
            return null;
        }
        orderLimit.setProduct(product);
        orderLimit.setMaxQuanity(product.mapQuantityFromBackend(from.getMaxQty()));
        orderLimit.setMaxAmount(product.mapPriceFromBackend(from.getMaxAmount()));
        return orderLimit;
    }
}

