/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.v6.PblcTradeConfType;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicTradeConfirmationMapper
extends AbstractMapper<PblcTradeConfType, PublicTradeConfirmation> {
    private static final Logger LOG = LoggerFactory.getLogger(PublicTradeConfirmationMapper.class);

    public PublicTradeConfirmationMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, PblcTradeConfType.class, PublicTradeConfirmation.class);
    }

    @Override
    public PublicTradeConfirmation translate(PblcTradeConfType from, MapperHandler mapperHandler, Object onBehalfUserId) {
        long tradeId = from.getTradeId();
        long contractId = from.getContractId();
        Contract contract = this.getContract(this.applicationContext, contractId, tradeId);
        if (contract == null) {
            return null;
        }
        Product product = contract.getProduct();
        PublicTradeConfirmation publicTradeConfirmation = new PublicTradeConfirmation();
        DeliveryArea buyDeliveryArea = this.getDeliveryArea(this.applicationContext, from.getBuyDlvryAreaId(), tradeId);
        DeliveryArea sellDeliveryArea = this.getDeliveryArea(this.applicationContext, from.getSellDlvryAreaId(), tradeId);
        if (buyDeliveryArea == null && sellDeliveryArea == null) {
            return null;
        }
        publicTradeConfirmation.setOnBehalf(onBehalfUserId != null);
        publicTradeConfirmation.setBuyDeliveryArea(buyDeliveryArea);
        publicTradeConfirmation.setContract(contract);
        publicTradeConfirmation.setPrice(product.mapPriceFromBackend(from.getPx()));
        publicTradeConfirmation.setQuantity(product.mapQuantityFromBackend(from.getQty()));
        publicTradeConfirmation.setRevisionNumber(from.getRevisionNo());
        publicTradeConfirmation.setState(EnumMapper.mapTradeState(from.getState()));
        publicTradeConfirmation.setTradeExecutionTime(DateTimeUtils.mapDateToDateTime(from.getTradeExecTime(), this.getExchange().getSystemInfo().getTimeZone()));
        publicTradeConfirmation.setSellDeliveryArea(sellDeliveryArea);
        publicTradeConfirmation.setId(tradeId);
        publicTradeConfirmation.setSelfTrade(Optional.ofNullable(from.isSelfTrade()).orElse(false));
        return publicTradeConfirmation;
    }

    private Contract getContract(ApplicationContext context, long contractId, long tradeId) {
        SmallFastDataModel<Long, Contract> dataModel = context.getSmallDataModel(Contract.class);
        Contract contract = (Contract)dataModel.findById(contractId);
        if (contract == null) {
            LOG.info("Unknown contract {} in the public trade confirmation {}", (Object)contractId, (Object)tradeId);
        }
        return contract;
    }

    private DeliveryArea getDeliveryArea(ApplicationContext context, String daEntityId, long tradeId) {
        SmallFastDataModel<String, DeliveryArea> dataModel = context.getSmallDataModel(DeliveryArea.class);
        DeliveryArea da = (DeliveryArea)dataModel.findById(daEntityId);
        if (da == null) {
            LOG.info("Unknown delivery area {} in the public trade confirmation {}", (Object)daEntityId, (Object)tradeId);
        }
        return da;
    }
}

