/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.message;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.message.MessageResourceBundle;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.stream.IntStream;

@Singleton
public class MessageFormatter {
    private final MessageResourceBundle messageResourceBundle = new MessageResourceBundle();

    public String formatError(int errorCode, Map<Integer, Object> variables) {
        return this.format(this.messageResourceBundle.getErrorKey(errorCode), variables);
    }

    public String formatMessage(int messageCode, Map<Integer, Object> variables) {
        return this.format(this.messageResourceBundle.getMessageKey(messageCode), variables);
    }

    private String format(String messageKey, Map<Integer, Object> variables) {
        try {
            MessageFormat messageFormat = new MessageFormat(this.messageResourceBundle.getMessageResourceBundle(Util.getCurrentLocale()).getString(messageKey));
            int variablesCount = messageFormat.getFormatsByArgumentIndex().length;
            Object[] arguments = IntStream.range(0, variablesCount).mapToObj(index -> variables.getOrDefault(index, "")).toArray();
            return messageFormat.format(arguments);
        }
        catch (NullPointerException | MissingResourceException e) {
            throw new IllegalArgumentException("Unknow message code ", e);
        }
    }
}

