/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.LargePersistableDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.MapModificationListener;
import org.mapdb.serializer.GroupSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LargePersistableDataModelBase<I extends Comparable<I>, T extends BroadcastEntity<I>>
implements LargePersistableDataModel<I, T> {
    private static final Logger LOG = LoggerFactory.getLogger(LargePersistableDataModelBase.class);
    private static final String LISTENER_ERROR = "Error when calling a DataModelListener";
    protected static final int BATCH_SIZE = 1024;
    private BTreeMap<I, T> entities;
    private final List<DataModelListener<T>> postListeners = new CopyOnWriteArrayList<DataModelListener<T>>();
    private final List<DataModelListener<T>> preListeners = new CopyOnWriteArrayList<DataModelListener<T>>();
    private final String mapName;
    private final ApplicationContext appContext;
    private final GroupSerializer<? extends Object> keySerializer;
    private final GroupSerializer<? extends Object> valueSerializer;

    protected LargePersistableDataModelBase(ApplicationContext appContext, String mapName, GroupSerializer keySerializer, GroupSerializer valueSerializer) {
        this.appContext = appContext;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.mapName = mapName;
    }

    protected void init(List<MapModificationListener> listeners) {
        DB.TreeMapMaker<? extends Object, ? extends Object> treeMapMaker = this.appContext.getService(DB.class).treeMap(this.mapName).keySerializer(this.keySerializer).valueSerializer(this.valueSerializer);
        listeners.forEach(treeMapMaker::modificationListener);
        this.entities = treeMapMaker.createOrOpen();
    }

    protected BTreeMap<I, T> getEntities() {
        return this.entities;
    }

    protected ApplicationContext getAppContext() {
        return this.appContext;
    }

    protected List<DataModelListener<T>> getListeners() {
        return this.postListeners;
    }

    @Override
    public T findById(I id) {
        return (T)((BroadcastEntity)this.entities.get(id));
    }

    @Override
    public boolean containsKey(I id) {
        return this.entities.containsKey(id);
    }

    @Override
    public T remove(T entity) {
        BroadcastEntity removed;
        this.notifyRemoveListeners(entity, this.preListeners);
        BroadcastEntity broadcastEntity = removed = entity != null ? (BroadcastEntity)this.entities.remove(((BroadcastEntity)entity).getId()) : null;
        if (removed != null) {
            this.notifyRemoveListeners(entity, this.postListeners);
        }
        return (T)removed;
    }

    @Override
    public void removeAll(Collection<T> entitiesToRemove) {
        this.notifyRemoveListeners(entitiesToRemove, this.preListeners);
        ArrayList<BroadcastEntity> removedEntities = new ArrayList<BroadcastEntity>();
        for (BroadcastEntity entity : entitiesToRemove) {
            BroadcastEntity removed = (BroadcastEntity)this.entities.remove(entity.getId());
            if (removed == null) continue;
            removedEntities.add(removed);
        }
        this.notifyRemoveListeners((Collection<T>)removedEntities, this.postListeners);
    }

    @Override
    public void removeAll() {
        this.notifyRemoveListeners(this.preListeners);
        this.getEntities().clear();
        this.notifyRemoveListeners(this.postListeners);
    }

    @Override
    public int size() {
        return this.entities.size();
    }

    protected void removeIds(Iterable<I> ids) {
        LinkedList removedEntities = new LinkedList();
        StreamSupport.stream(ids.spliterator(), false).map(this.entities::get).filter(Objects::nonNull).forEach(removedEntities::add);
        this.notifyRemoveListeners(removedEntities, this.preListeners);
        removedEntities.stream().map(BroadcastEntity::getId).forEach(this.entities::remove);
        this.notifyRemoveListeners(removedEntities, this.postListeners);
    }

    @Override
    public void registerHencePreOperationListener(DataModelListener<T> dataModelListener) {
        this.preListeners.add(dataModelListener);
    }

    @Override
    public void registerHencePostOperationListener(DataModelListener<T> dataModelListener) {
        this.postListeners.add(dataModelListener);
    }

    @Override
    public void unregisterListener(DataModelListener<T> dataModelListener) {
        this.preListeners.remove(dataModelListener);
        this.postListeners.remove(dataModelListener);
    }

    @Override
    public void handleBroadcastEntity(T broadcastEntity) {
        if (broadcastEntity != null) {
            if (this.entities.containsKey(((BroadcastEntity)broadcastEntity).getId())) {
                this.notifyUpdateListeners(broadcastEntity, this.preListeners);
                this.notifyUpdateListeners(this.add(broadcastEntity), this.postListeners);
            } else {
                this.notifyAddListeners(broadcastEntity, this.preListeners);
                this.notifyAddListeners(this.add(broadcastEntity), this.postListeners);
            }
        }
    }

    protected abstract T add(T var1);

    @Override
    public void handleBroadcastEntities(Collection<T> broadcastEntities) {
        if (broadcastEntities == null) {
            return;
        }
        ArrayList<BroadcastEntity> toAdd = new ArrayList<BroadcastEntity>();
        ArrayList<BroadcastEntity> toUpdate = new ArrayList<BroadcastEntity>();
        int counter = 0;
        for (BroadcastEntity entity : broadcastEntities) {
            if (this.entities.containsKey(entity.getId())) {
                toUpdate.add(entity);
            } else {
                toAdd.add(entity);
            }
            if (++counter % 1024 != 0) continue;
            this.notify(toAdd, toUpdate);
            toAdd = new ArrayList(1024);
            toUpdate = new ArrayList(1024);
        }
        this.notify(toAdd, toUpdate);
    }

    private void notify(ArrayList<T> toAdd, ArrayList<T> toUpdate) {
        this.notifyUpdateListeners((Collection<T>)toUpdate, this.preListeners);
        this.notifyUpdateListeners((Collection<T>)toUpdate.stream().map(this::add).toList(), this.postListeners);
        this.notifyAddListeners((Collection<T>)toAdd, this.preListeners);
        this.notifyAddListeners((Collection<T>)toAdd.stream().map(this::add).toList(), this.postListeners);
    }

    @Override
    public void foreach(Consumer<T> consumer) {
        LOG.warn("Iterating over all elements of large datamodel. This may take some time.");
        this.entities.forEach((id, entity) -> consumer.accept(entity));
    }

    private void notifyRemoveListeners(T object, List<DataModelListener<T>> listeners) {
        if (object != null) {
            for (DataModelListener<T> listener : listeners) {
                try {
                    if (listener.notifyRemove(object) != DataModelListener.NotificationResult.REMOVE_LISTENER) continue;
                    listeners.remove(listener);
                }
                catch (RuntimeException e) {
                    LOG.error(LISTENER_ERROR, e);
                }
            }
        }
    }

    private void notifyRemoveListeners(Collection<T> objects, List<DataModelListener<T>> listeners) {
        if (objects != null && !objects.isEmpty()) {
            for (DataModelListener<T> listener : listeners) {
                try {
                    if (listener.notifyRemoveAll(objects) != DataModelListener.NotificationResult.REMOVE_LISTENER) continue;
                    listeners.remove(listener);
                }
                catch (RuntimeException e) {
                    LOG.error(LISTENER_ERROR, e);
                }
            }
        }
    }

    private void notifyRemoveListeners(List<DataModelListener<T>> listeners) {
        for (DataModelListener<T> listener : listeners) {
            try {
                if (listener.notifyRemoveAll() != DataModelListener.NotificationResult.REMOVE_LISTENER) continue;
                listeners.remove(listener);
            }
            catch (RuntimeException e) {
                LOG.error(LISTENER_ERROR, e);
            }
        }
    }

    private void notifyUpdateListeners(T object, List<DataModelListener<T>> listeners) {
        if (object != null) {
            for (DataModelListener<T> listener : listeners) {
                try {
                    if (listener.notifyUpdate(object) != DataModelListener.NotificationResult.REMOVE_LISTENER) continue;
                    listeners.remove(listener);
                }
                catch (RuntimeException e) {
                    LOG.error(LISTENER_ERROR, e);
                }
            }
        }
    }

    private void notifyAddListeners(T object, List<DataModelListener<T>> listeners) {
        if (object != null) {
            for (DataModelListener<T> listener : listeners) {
                try {
                    if (listener.notifyAdd(object) != DataModelListener.NotificationResult.REMOVE_LISTENER) continue;
                    listeners.remove(listener);
                }
                catch (RuntimeException e) {
                    LOG.error(LISTENER_ERROR, e);
                }
            }
        }
    }

    private void notifyUpdateListeners(Collection<T> objects, List<DataModelListener<T>> listeners) {
        if (objects != null && !objects.isEmpty()) {
            for (DataModelListener<T> listener : listeners) {
                try {
                    if (listener.notifyUpdateAll(objects) != DataModelListener.NotificationResult.REMOVE_LISTENER) continue;
                    listeners.remove(listener);
                }
                catch (RuntimeException e) {
                    LOG.error(LISTENER_ERROR, e);
                }
            }
        }
    }

    private void notifyAddListeners(Collection<T> objects, List<DataModelListener<T>> listeners) {
        if (objects != null && !objects.isEmpty()) {
            for (DataModelListener<T> listener : listeners) {
                try {
                    if (listener.notifyAddAll(objects) != DataModelListener.NotificationResult.REMOVE_LISTENER) continue;
                    listeners.remove(listener);
                }
                catch (RuntimeException e) {
                    LOG.error(LISTENER_ERROR, e);
                }
            }
        }
    }
}

