/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class AbstractDataQuery<T extends BroadcastEntity>
implements DataQuery<T> {
    private final Predicate<T> filter;

    protected AbstractDataQuery() {
        this.filter = i -> true;
    }

    protected AbstractDataQuery(Predicate<T> filter) {
        this.filter = filter;
    }

    @Override
    public DataQuery<T> addFilter(Predicate<T> filter) {
        return this.newInstance(this.filter.and(filter));
    }

    protected abstract DataQuery<T> newInstance(Predicate<T> var1);

    protected Predicate<T> getFilter() {
        return this.filter;
    }

    @Override
    public <S extends T> DataQuery<S> filterAndCast(Class<S> targetType) {
        return new FilterAndCastQuery(this, targetType);
    }

    private static final class FilterAndCastQuery<T extends BroadcastEntity, S extends T>
    implements DataQuery<S> {
        private final DataQuery<T> delegate;
        private final Class<S> targetType;

        public FilterAndCastQuery(DataQuery<T> delegate, Class<S> targetType) {
            this.delegate = delegate.addFilter(targetType::isInstance);
            this.targetType = targetType;
        }

        @Override
        public DataQuery<S> addFilter(Predicate<S> filter) {
            DataQuery<BroadcastEntity> newDelegate = this.delegate.addFilter((T t) -> filter.test(t));
            return new FilterAndCastQuery<BroadcastEntity, S>(newDelegate, this.targetType);
        }

        @Override
        public Stream<S> getAll() {
            return this.delegate.getAll().map(this.targetType::cast);
        }

        @Override
        public Optional<S> getFirst() {
            return this.delegate.getFirst().map(this.targetType::cast);
        }

        @Override
        public <U extends S> DataQuery<U> filterAndCast(Class<U> targetType) {
            return new FilterAndCastQuery<T, U>(this, targetType);
        }
    }
}

