/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.BestOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ComputedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryLookup;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.VWapUtil;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdatable;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateAdapter;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateListeners;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.WeakBatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractComputedOrderbookEntries<E extends CommonOrderbookEntry>
implements BatchUpdatable<E>,
ComputedOrderbookEntries<E> {
    protected final OrderbookEntries rawEntries;
    protected final List<E> entries;
    private final BatchUpdateListeners<E> listeners;
    protected final OrderbookEntryLookup orderbookEntryLookup;
    protected final Orderbook orderbook;
    protected final BestOrderbookEntry bestEntry;
    private final BatchUpdateListener<OrderbookEntry> rawEntriesListener;
    private final BatchUpdateListener<OrderbookEntry> blockVwapUpdateListener;

    public AbstractComputedOrderbookEntries(Orderbook orderbook, Direction direction) {
        this.orderbook = orderbook;
        this.rawEntries = direction == Direction.BUY ? orderbook.getBuys() : orderbook.getSells();
        this.orderbookEntryLookup = orderbook.getOrderbookEntryLookup();
        this.entries = new ArrayList();
        this.listeners = new BatchUpdateListeners();
        this.bestEntry = new BestOrderbookEntry();
        this.rawEntriesListener = new BatchUpdateListener<OrderbookEntry>(){
            private int minIndexChanged;

            @Override
            public BatchUpdateListener.NotificationResult batchStarted() {
                AbstractComputedOrderbookEntries.this.listeners.batchStarted();
                this.minIndexChanged = AbstractComputedOrderbookEntries.this.size();
                return BatchUpdateListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public BatchUpdateListener.NotificationResult batchFinished() {
                AbstractComputedOrderbookEntries.this.rawEntriesBatchUpdateFinished(this.minIndexChanged);
                AbstractComputedOrderbookEntries.this.listeners.batchFinished();
                AbstractComputedOrderbookEntries.this.updateBestEntry();
                return BatchUpdateListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public BatchUpdateListener.NotificationResult itemAdded(OrderbookEntry newRawEntry) {
                int sizeBefore = AbstractComputedOrderbookEntries.this.size();
                int index = AbstractComputedOrderbookEntries.this.rawEntryAdded(newRawEntry);
                if (index != -1) {
                    this.minIndexChanged = Math.min(index, this.minIndexChanged);
                    if (AbstractComputedOrderbookEntries.this.size() > sizeBefore) {
                        CommonOrderbookEntry newEntry = (CommonOrderbookEntry)AbstractComputedOrderbookEntries.this.entries.get(index);
                        AbstractComputedOrderbookEntries.this.listeners.itemAdded(newEntry);
                    }
                }
                return BatchUpdateListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public BatchUpdateListener.NotificationResult itemRemoved(OrderbookEntry removedRawEntry) {
                int index = AbstractComputedOrderbookEntries.this.rawEntryRemoved(removedRawEntry);
                if (index >= 0) {
                    this.minIndexChanged = Math.min(index, this.minIndexChanged);
                    CommonOrderbookEntry removedEntry = (CommonOrderbookEntry)AbstractComputedOrderbookEntries.this.entries.remove(index);
                    AbstractComputedOrderbookEntries.this.listeners.itemRemoved(removedEntry);
                } else {
                    this.minIndexChanged = Math.min(-index - 1, this.minIndexChanged);
                }
                return BatchUpdateListener.NotificationResult.RETAIN_LISTENER;
            }
        };
        this.rawEntries.addListener((BatchUpdateListener<OrderbookEntry>)new WeakBatchUpdateListener<OrderbookEntry>(this.rawEntriesListener));
        this.blockVwapUpdateListener = BatchUpdateAdapter.batchFinishedListener(this::reloadBlockVwap);
        if (orderbook.getContract().getType().isBlock()) {
            orderbook.getOrderbooksForVwapCalculation().stream().map(orderbookForVwapCalculation -> direction.isBuy() ? orderbookForVwapCalculation.getBuys() : orderbookForVwapCalculation.getSells()).forEach(entriesForVwapCalculation -> entriesForVwapCalculation.addListener(this.blockVwapUpdateListener));
        }
    }

    private void reloadBlockVwap() {
        this.listeners.batchStarted();
        this.reloadVwapAndAccQty(0);
        this.listeners.batchFinished();
    }

    protected void reloadVwapAndAccQty(int fromIndex) {
        if (this.getContract().getType().isCanonical()) {
            VWapUtil.updateCanonicalVwapAndAccQty(this.entries, fromIndex);
        } else {
            VWapUtil.updateBlockVwapAndAccQty(this.entries, this.orderbook.getOrderbooksForVwapCalculation(), this.getDirection());
        }
    }

    protected void updateBestEntry() {
        if (this.entries.isEmpty()) {
            this.bestEntry.setPrice(null);
            this.bestEntry.setQuantity(null);
            this.bestEntry.setOwnQuantity(null);
            this.bestEntry.setSource(null);
        } else {
            this.loadBestEntryValue();
        }
    }

    protected abstract void loadBestEntryValue();

    protected abstract void reloadTradability();

    protected abstract void reloadOwnQuantities();

    protected void rawEntriesBatchUpdateFinished(int minIndexChanged) {
        if (this.size() > 0 && minIndexChanged < this.size()) {
            this.reloadVwapAndAccQty(minIndexChanged);
        }
    }

    protected abstract int rawEntryAdded(OrderbookEntry var1);

    protected abstract int rawEntryRemoved(OrderbookEntry var1);

    void reloadUserDependentValues() {
        this.listeners.batchStarted();
        this.reloadOwnQuantities();
        this.reloadTradability();
        this.listeners.batchFinished();
    }

    @Override
    public List<E> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public Contract getContract() {
        return this.orderbook.getContract();
    }

    public DeliveryArea getDeliveryArea() {
        return this.orderbook.getDeliveryArea();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    public Direction getDirection() {
        return this.rawEntries.getDirection();
    }

    @Override
    public void addListener(BatchUpdateListener<E> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeListener(BatchUpdateListener<E> listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public BestOrderbookEntry getBestEntry() {
        return this.bestEntry;
    }
}

