/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdatable;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateListeners;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class OrderbookEntries
implements BatchUpdatable<OrderbookEntry> {
    private final Map<Long, OrderbookEntry> entries;
    private final BatchUpdateListeners<OrderbookEntry> listeners;
    private final Direction direction;

    public OrderbookEntries(@Nonnull Direction direction) {
        this.direction = direction;
        this.entries = new HashMap<Long, OrderbookEntry>();
        this.listeners = new BatchUpdateListeners();
    }

    public OrderbookEntries(@Nonnull OrderbookEntries other) {
        this.direction = other.getDirection();
        this.entries = new HashMap<Long, OrderbookEntry>(other.entries);
        this.listeners = new BatchUpdateListeners();
    }

    public Collection<OrderbookEntry> getEntriesAsCollection() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    public Set<OrderbookEntry> getEntries() {
        return new HashSet<OrderbookEntry>(this.entries.values());
    }

    public SortedSet<OrderbookEntry> getSortedEntries() {
        TreeSet<OrderbookEntry> result = new TreeSet<OrderbookEntry>(OrderbookEntry.getDefaultComparator(this.direction));
        result.addAll(this.entries.values());
        return result;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int size() {
        return this.entries.size();
    }

    @Override
    public void addListener(BatchUpdateListener<OrderbookEntry> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeListener(BatchUpdateListener<OrderbookEntry> listener) {
        this.listeners.removeListener(listener);
    }

    public void batchStarted() {
        this.listeners.batchStarted();
    }

    void clear() {
        Iterator<Map.Entry<Long, OrderbookEntry>> iterator2 = this.entries.entrySet().iterator();
        while (iterator2.hasNext()) {
            OrderbookEntry entry = iterator2.next().getValue();
            iterator2.remove();
            this.listeners.itemRemoved(entry);
        }
    }

    public void remove(OrderbookEntry entry) {
        OrderbookEntry removedEntry = this.entries.remove(entry.getOrderId());
        if (removedEntry != null) {
            this.listeners.itemRemoved(removedEntry);
        }
    }

    void addAll(Set<OrderbookEntry> entriesToAdd) {
        entriesToAdd.stream().forEach(this::add);
    }

    public void add(OrderbookEntry entry) {
        if (!this.entries.containsKey(entry.getOrderId())) {
            this.entries.put(entry.getOrderId(), entry);
            this.listeners.itemAdded(entry);
        }
    }

    public void batchFinished() {
        this.listeners.batchFinished();
    }

    public OrderbookEntry getEntry(long orderId) {
        return this.entries.get(orderId);
    }
}

