/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.BespokeContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.AggressorIndicatorType;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeType;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke.BespokeContractEditorPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke.BespokeValidator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke.TradeSidePane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DefaultButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.OptContractField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ProductField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.SimpleLongDisplayValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.TextFieldWithLengthLimit;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AllDescendantsByIdOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.service.NotificationService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.trade.BespokeService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;

@DraggableComponent(forUserWithUserRole={"ROLE_ADMIN", "ROLE_BROKER"}, nameKey="bespokeTradesPanel_header_label", descriptionKey="bespokeTradesPanel_description")
@OverrideGuiConfiguration(field="#this", overrideId="BespokeTradesPanel", strategy=AllDescendantsByIdOverrideGuiStrategy.class)
public class BespokeTradesPanel
extends AbstractPanel {
    @FXML
    private DefaultButton submitButton;
    @FXML
    private Button cancelButton;
    @FXML
    private Button newContractButton;
    @FXML
    private Label underlyingContractsLabel;
    @FXML
    private Label underlyingContractsText;
    @FXML
    private OptContractField contractField;
    @FXML
    private ProductField productField;
    @FXML
    private TradeSidePane buySide;
    @FXML
    private TradeSidePane sellSide;
    @FXML
    private SimpleLongDisplayValueField tradeQuantityField;
    @FXML
    private SimpleLongDisplayValueField tradePriceField;
    @FXML
    private CheckBox pncTradeCheckBox;
    @FXML
    private TextFieldWithLengthLimit textField;
    private BespokeContractEditorPane contractEditorPane;
    private final SmallFastDataModel<Long, Contract> contractDataModel;
    private final BespokeService bespokeService;
    private final UserService userService;
    private final UserAlertService userAlertService;
    private final ContractQueries contractQueries;
    private final BespokeValidator bespokeValidator;
    private final NotificationService.Notifier notifier;
    private final SimpleObjectProperty<ObservableList<BespokeContract>> bespokeContractsObservable;
    private final SimpleBooleanProperty isPnCEnabled;
    private final SimpleBooleanProperty isBrokerOrAdmin;
    private DependentBinding<LongDisplayValue> minimumPriceBinding;
    private DependentBinding<LongDisplayValue> maximumPriceBinding;
    private final DataModelListener<Contract> bespokeContractDataModelListener;
    private final ObservableObjectValue<Exchange> activeExchange;
    private final ChangeListener<Exchange> activeExchangeChange;

    public BespokeTradesPanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public BespokeTradesPanel(ApplicationContext appContext) {
        super(appContext);
        this.contractDataModel = appContext.getSmallDataModel(Contract.class);
        this.bespokeService = appContext.getService(BespokeService.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.contractQueries = appContext.getService(ContractQueries.class);
        NotificationService.Notifier notifier = appContext.getService(NotificationService.class).createNotifier(this, Pos.BOTTOM_CENTER);
        this.bespokeValidator = new BespokeValidator(notifier, this.contractQueries);
        this.activeExchange = appContext.getService(ActiveExchange.class).getActiveExchange();
        this.bespokeContractsObservable = new SimpleObjectProperty(FXCollections.observableArrayList());
        this.isPnCEnabled = new SimpleBooleanProperty(false);
        this.isBrokerOrAdmin = new SimpleBooleanProperty(false);
        this.userService = appContext.getService(UserService.class);
        this.bespokeContractDataModelListener = this.createBespokeContractsDataModelListener();
        this.notifier = appContext.getService(NotificationService.class).createNotifier(this, Pos.CENTER_LEFT);
        this.activeExchangeChange = (observable2, oldValue, newValue) -> {
            ((ObservableList)this.bespokeContractsObservable.get()).clear();
            this.contractQueries.findActiveBespokeContracts().getAll().forEach(((ObservableList)this.bespokeContractsObservable.get())::add);
            this.resetFields();
        };
        this.activeExchange.addListener(new WeakChangeListener<Exchange>(this.activeExchangeChange));
        this.loadFxml();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.contractDataModel.registerListener(new WeakDataModelListener<Contract>(this.bespokeContractDataModelListener));
        this.newContractButton.disableProperty().bind(this.isBrokerOrAdmin.not());
        this.underlyingContractsLabel.visibleProperty().bind(Bindings.isNotEmpty(this.underlyingContractsText.textProperty()));
        this.underlyingContractsText.visibleProperty().bind(Bindings.isNotEmpty(this.underlyingContractsText.textProperty()));
        this.bespokeProductFieldInit();
        this.bespokeContractFieldInit();
        this.tradeSidesInit();
        this.tradeQuantityInit();
        this.initSubmitButton();
        this.pncInit();
        this.tradePriceFieldsInit();
        this.isBrokerOrAdminInit();
        this.bespokeTextInit();
    }

    private void bespokeTextInit() {
        Tooltip underlyingContractLabelTooltip = new Tooltip();
        underlyingContractLabelTooltip.textProperty().bind(this.underlyingContractsText.textProperty());
        Tooltip.install(this.underlyingContractsText, underlyingContractLabelTooltip);
        this.contractField.valueProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue instanceof BespokeContract) {
                BespokeContract contract = (BespokeContract)newValue;
                String underlyingContractText = contract.getUnderlyingContracts().stream().sorted(Contract.DEFAULT_DISPLAY_COMPARATOR).map(Contract::getName).collect(Collectors.joining(", "));
                if (contract.isOption()) {
                    this.underlyingContractsText.setText(underlyingContractText + " - " + String.valueOf(contract.getStrikePrc()) + " " + String.valueOf((Object)contract.getPutOrCall()));
                } else {
                    this.underlyingContractsText.setText(underlyingContractText);
                }
            } else {
                this.underlyingContractsText.setText("");
            }
        });
    }

    private AbstractDataModelListener<Contract> createBespokeContractsDataModelListener() {
        return new AbstractDataModelListener<Contract>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(Contract object) {
                if (object instanceof BespokeContract && object.getCompoundStatus().getContractStatus().isActive()) {
                    ((ObservableList)BespokeTradesPanel.this.bespokeContractsObservable.get()).add((BespokeContract)object);
                }
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyAddAll(Collection<Contract> objects) {
                for (Contract object : objects) {
                    if (!(object instanceof BespokeContract) || !object.getCompoundStatus().getContractStatus().isActive()) continue;
                    ((ObservableList)BespokeTradesPanel.this.bespokeContractsObservable.get()).add((BespokeContract)object);
                }
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        };
    }

    private void initSubmitButton() {
        this.submitButton.disableProperty().bind(this.isBrokerOrAdmin.not().or(this.tradeQuantityField.validProperty().and(this.tradePriceField.validProperty()).and(this.sellSide.validProperty()).and(this.buySide.validProperty()).not()));
    }

    private void pncInit() {
        this.isPnCEnabled.bind((ObservableValue<? extends Boolean>)new DependentBinding<Boolean>(new Observable[]{this.contractField.valueProperty()}){

            @Override
            protected Boolean computeValue() {
                if (BespokeTradesPanel.this.contractField.valueProperty().get() != null) {
                    if (BespokeTradesPanel.this.contractField.getValue() instanceof BespokeContract) {
                        BespokeTradesPanel.this.pncTradeCheckBox.setSelected(true);
                    } else {
                        BespokeTradesPanel.this.pncTradeCheckBox.setSelected(false);
                    }
                    return !(BespokeTradesPanel.this.contractField.getValue() instanceof BespokeContract) && !((Contract)BespokeTradesPanel.this.contractField.getValue()).getProduct().isGlobalProduct() && ((Contract)BespokeTradesPanel.this.contractField.getValue()).getProduct().isPrivateAndConfidential();
                }
                return false;
            }
        });
        this.pncTradeCheckBox.disableProperty().bind(this.isPnCEnabled.not());
        this.activeExchange.addListener((observable2, oldValue, newValue) -> this.showOrHidePnCCheckBox());
    }

    private void showOrHidePnCCheckBox() {
        if (this.activeExchange.getValue() != null) {
            this.pncTradeCheckBox.setVisible(((Exchange)this.activeExchange.getValue()).getSystemInfo().supportsPncOrders());
        } else {
            this.pncTradeCheckBox.setVisible(false);
        }
    }

    @Subscribe
    public void handlefinishedInitialLoading(EntityLoadingFinishedEvent<?> event) {
        this.showOrHidePnCCheckBox();
    }

    private void isBrokerOrAdminInit() {
        this.activeExchange.addListener((observable2, oldValue, newValue) -> this.reloadIsBrokerOrAdminFlag());
        this.reloadIsBrokerOrAdminFlag();
    }

    public void reloadIsBrokerOrAdminFlag() {
        if (this.activeExchange.getValue() != null) {
            User ownUser = this.userService.getOwnUser();
            this.isBrokerOrAdmin.set(ownUser.getRoles().isBroker() || ownUser.getRoles().isAdmin());
        } else {
            this.isBrokerOrAdmin.set(false);
        }
    }

    private void bespokeContractFieldInit() {
        this.contractField.productProperty().bind(this.productProperty());
        this.contractField.valueProperty().addListener((observable2, oldValue, newValue) -> this.resetFields());
        this.contractField.disableProperty().bind(Bindings.isNull(this.contractField.productProperty()));
    }

    private void bespokeProductFieldInit() {
        this.productField.valueProperty().addListener((observable2, oldValue, newValue) -> {
            this.resetFields();
            this.contractField.setText(null);
        });
    }

    private void tradePriceFieldsInit() {
        this.minimumPriceBinding = new DependentBinding<LongDisplayValue>(new Observable[]{this.contractField.valueProperty()}){

            @Override
            protected LongDisplayValue computeValue() {
                Contract contract = (Contract)BespokeTradesPanel.this.contractField.getValue();
                if (contract != null) {
                    if (contract instanceof BespokeContract && contract.isOption()) {
                        return new LongDisplayValue(1L, contract.getProduct().getPriceDecimalShift());
                    }
                    return contract.getProduct().getPriceMinValue();
                }
                return new LongDisplayValue(0L, 0);
            }
        };
        this.maximumPriceBinding = new DependentBinding<LongDisplayValue>(new Observable[]{this.contractField.valueProperty()}){

            @Override
            protected LongDisplayValue computeValue() {
                Contract contract = (Contract)BespokeTradesPanel.this.contractField.getValue();
                if (contract != null) {
                    if (contract instanceof BespokeContract && contract.isOption()) {
                        return new LongDisplayValue(Integer.MAX_VALUE, contract.getProduct().getPriceDecimalShift());
                    }
                    return contract.getProduct().getPriceMaxValue();
                }
                return new LongDisplayValue(Integer.MAX_VALUE, 0);
            }
        };
        this.tradePriceField.minimumProperty().bind(this.minimumPriceBinding);
        this.tradePriceField.maximumProperty().bind(this.maximumPriceBinding);
        this.tradePriceField.textFieldFocusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (this.contractField.getValue() != null && (!oldValue.booleanValue() && newValue.booleanValue() || this.tradePriceField.isValid())) {
                Product product = ((Contract)this.contractField.getValue()).getProduct();
                LongDisplayValue oldPrice = this.tradePriceField.getValue();
                this.tradePriceField.setValue((oldPrice != null ? oldPrice : LongDisplayValue.ZERO).applyShift(product.getPriceDecimalShift()));
                this.tradePriceField.setDelta((int)product.getPriceTickSize().getValue());
            } else {
                LongDisplayValue oldQuantity = this.tradePriceField.getValue();
                this.tradePriceField.setValue(oldQuantity != null ? oldQuantity : LongDisplayValue.ZERO);
                this.tradePriceField.setDelta(1);
            }
        });
        this.tradePriceField.textFieldFocusedProperty().addListener((observable2, oldValue, newValue) -> {
            if (this.contractField.getValue() != null && this.tradePriceField.getValue() != null && oldValue.booleanValue() && !newValue.booleanValue()) {
                this.tradePriceField.setValue(this.tradePriceField.getValue().applyShift(((Contract)this.contractField.getValue()).getProduct().getPriceDecimalShift()));
            }
        });
    }

    private void tradeQuantityInit() {
        DependentBinding<LongDisplayValue> minimumQuantityBinding = new DependentBinding<LongDisplayValue>(new Observable[]{this.contractField.valueProperty()}){

            @Override
            protected LongDisplayValue computeValue() {
                Contract contract = (Contract)BespokeTradesPanel.this.contractField.getValue();
                if (contract != null) {
                    return ((Contract)BespokeTradesPanel.this.contractField.getValue()).getProduct().getQuantityMinValue();
                }
                return new LongDisplayValue(0L, 0);
            }
        };
        DependentBinding<LongDisplayValue> maximumQuantityBinding = new DependentBinding<LongDisplayValue>(new Observable[]{this.contractField.valueProperty()}){

            @Override
            protected LongDisplayValue computeValue() {
                if (BespokeTradesPanel.this.contractField.getValue() != null) {
                    return ((Contract)BespokeTradesPanel.this.contractField.getValue()).getProduct().getQuantityMaxValue();
                }
                return new LongDisplayValue(Integer.MAX_VALUE, 0);
            }
        };
        this.tradeQuantityField.minimumProperty().bind((ObservableValue<LongDisplayValue>)minimumQuantityBinding);
        this.tradeQuantityField.maximumProperty().bind((ObservableValue<LongDisplayValue>)maximumQuantityBinding);
        this.tradeQuantityField.textFieldFocusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (this.contractField.getValue() != null) {
                if (newValue.booleanValue()) {
                    LongDisplayValue oldQuantity = this.tradeQuantityField.getValue();
                    Product product = ((Contract)this.contractField.getValue()).getProduct();
                    this.tradeQuantityField.setValue((oldQuantity != null ? oldQuantity : LongDisplayValue.ZERO).applyShift(product.getQuantityDecimalShift()));
                    this.tradeQuantityField.setDelta((int)product.getQuantityLotSize().getValue());
                }
            } else {
                LongDisplayValue oldQuantity = this.tradeQuantityField.getValue();
                this.tradeQuantityField.setValue(oldQuantity != null ? oldQuantity : LongDisplayValue.ZERO);
                this.tradeQuantityField.setDelta(1);
            }
        });
        this.tradeQuantityField.textFieldFocusedProperty().addListener((observable2, oldValue, newValue) -> {
            if (this.contractField.getValue() != null && this.tradeQuantityField.getValue() != null && oldValue.booleanValue() && !newValue.booleanValue()) {
                this.tradeQuantityField.setValue(this.tradeQuantityField.getValue().applyShift(((Contract)this.contractField.getValue()).getProduct().getQuantityDecimalShift()));
            }
        });
    }

    private void tradeSidesInit() {
        DependentBinding<Product> product = this.getProductDependentBinding();
        this.buySide.productProperty().bind(product);
        this.sellSide.productProperty().bind(product);
    }

    private DependentBinding<Product> getProductDependentBinding() {
        return DependentBinding.get(Contract::getProduct, this.contractField.valueProperty());
    }

    private FullTrade createBespokeTrade() {
        FullTrade trade = new FullTrade();
        trade.setTradeType(TradeType.PREARRANGED);
        trade.setPrice(this.tradePriceField.getValue());
        trade.setQuantity(this.tradeQuantityField.getValue());
        trade.setBuyHalfTrade(this.createHalfTrade(this.buySide, Direction.BUY));
        trade.setSellHalfTrade(this.createHalfTrade(this.sellSide, Direction.SELL));
        return trade;
    }

    private HalfTrade createHalfTrade(TradeSidePane tradeSidePane, Direction direction) {
        HalfTrade trade = new HalfTrade();
        trade.setOrder(this.createOrderInfo(tradeSidePane, direction));
        return trade;
    }

    private Trade.OrderInfo createOrderInfo(TradeSidePane tradeSidePane, Direction direction) {
        return new Trade.OrderInfo(null, direction, (Integer)((User)tradeSidePane.getBrokerTraderField().getValue()).getId(), (User)tradeSidePane.getBrokerTraderField().getValue(), (String)((Member)tradeSidePane.getMemberField().getValue()).getId(), ((User)tradeSidePane.getTraderField().getValue()).getUserCode(), (User)tradeSidePane.getTraderField().getValue(), (String)((DeliveryArea)tradeSidePane.getDeliveryAreaChoiceBox().getValue()).getId(), null, (String)((BalancingGroup)tradeSidePane.getBalancingGroupField().getValue()).getId(), (BalancingGroup)tradeSidePane.getBalancingGroupField().getValue(), this.activeExchange.get().getSystemInfo().getAllowedClearingAccountTypes().stream().findFirst().orElse(""), this.textField.getText(), tradeSidePane.getIsOpenClose() ? (OpenOrClose)tradeSidePane.getOpenOrCloseField().getValue() : null, null, AggressorIndicatorType.U);
    }

    private void resetFields() {
        this.buySide.resetFields();
        this.sellSide.resetFields();
        this.tradeQuantityField.setValue(null);
        this.tradePriceField.setValue(null);
        this.textField.setText("");
    }

    private void handleResponse(AsyncResponse response) {
        FxUtil.runInFxThread(() -> {
            if (response.getStatus() == ResponseStatus.SUCCESS) {
                this.productField.clear();
                this.resetFields();
            }
            this.notifier.showNotification(response);
        });
    }

    @FXML
    public void submit() {
        FullTrade trade = this.createBespokeTrade();
        if (this.bespokeValidator.isValidTrade(trade) && this.hasNoTradeWarnings(trade)) {
            trade.setContract((Contract)this.contractField.getValue());
            this.bespokeService.createBespokeTrade(trade, this.pncTradeCheckBox.isSelected(), this::handleResponse);
        }
    }

    public boolean hasNoTradeWarnings(FullTrade trade) {
        return !trade.getBuyOrder().getMemberCode().equals(trade.getSellOrder().getMemberCode()) || !trade.getBuyOrder().getTraderUserCode().equals(trade.getSellOrder().getTraderUserCode()) || this.userAlertService.showQuestionDialog(Util.getLabel("commons_sendOrderQuestion"), Util.getLabel("prearrangedTradeProtection_order_question"), new UserAlertService.Flag[0]);
    }

    @FXML
    public void cancel() {
        this.productField.clear();
        this.resetFields();
    }

    @FXML
    public void newBespokeContract() {
        this.contractEditorPane = new BespokeContractEditorPane(this.getAppContext(), this);
        this.contractEditorPane.showPanel();
    }

    public ReadOnlyProperty<Product> productProperty() {
        return this.productField.valueProperty();
    }

    public void fillContract(BespokeContract contract) {
        this.productField.setText(contract.getProduct().getName());
        this.contractField.setText(contract.getName());
    }
}

