/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.chart;

import javafx.beans.value.ObservableValue;
import javafx.scene.chart.ValueAxis;

public class AxisWithPadding {
    private final ValueAxis<Number> axis;
    private final ObservableValue<Number> minValue;
    private final ObservableValue<Number> maxValue;
    private final double paddingRelativeToRange;

    public AxisWithPadding(ValueAxis<Number> axis, ObservableValue<Number> minValue, ObservableValue<Number> maxValue, double paddingRelativeToRange) {
        this.axis = axis;
        this.minValue = minValue;
        this.maxValue = maxValue;
        minValue.addListener(observable2 -> this.setPadding());
        maxValue.addListener(observable2 -> this.setPadding());
        this.paddingRelativeToRange = paddingRelativeToRange;
    }

    private void setPadding() {
        double max = this.maxValue.getValue().doubleValue();
        double min = this.minValue.getValue().doubleValue();
        double range = max - min;
        double padding = range * this.paddingRelativeToRange;
        this.axis.setLowerBound(min - padding);
        this.axis.setUpperBound(max + padding);
    }
}

