/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.chart;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeState;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.XYChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeChartSeries
extends AbstractDataModelListener<PublicTradeConfirmation> {
    private static final Logger LOG = LoggerFactory.getLogger(TradeChartSeries.class);
    private final SmallFastDataModel<Long, PublicTradeConfirmation> publicTradeConfirmationDataModel;
    private final XYChart.Series<Number, Number> chartSeries;
    private final ObservableList<XYChart.Data<Number, Number>> data;
    private final Contract contract;
    private final MarketArea marketArea;
    private final Function<PublicTradeConfirmation, LongDisplayValue> tradeProperty;
    private final Predicate<PublicTradeConfirmation> displayFilter;
    private final boolean aggregateValuesWithSameTimestamp;
    private final ObjectProperty<Number> minXValue;
    private final ObjectProperty<Number> maxXValue;

    TradeChartSeries(ApplicationContext applicationContext, Contract contract, MarketArea marketArea, Function<PublicTradeConfirmation, LongDisplayValue> tradeProperty, Predicate<PublicTradeConfirmation> displayFilter, boolean aggregateValuesWithSameTimestamp) {
        this.contract = contract;
        this.marketArea = marketArea;
        this.tradeProperty = tradeProperty;
        this.displayFilter = displayFilter;
        this.aggregateValuesWithSameTimestamp = aggregateValuesWithSameTimestamp;
        this.minXValue = new SimpleObjectProperty<Integer>(0);
        this.maxXValue = new SimpleObjectProperty<Integer>(0);
        this.data = FXCollections.observableArrayList();
        this.chartSeries = new XYChart.Series(this.data);
        this.chartSeries.setName(null);
        this.publicTradeConfirmationDataModel = applicationContext.getSmallDataModel(PublicTradeConfirmation.class);
        this.reloadChart();
        this.publicTradeConfirmationDataModel.registerHencePostOperationListener(new WeakDataModelListener<PublicTradeConfirmation>(this));
    }

    void reloadChart() {
        LOG.info("Reloading chart for contract {} and market area {}", (Object)this.contract.getName(), (Object)this.marketArea.getName());
        this.data.clear();
        this.publicTradeConfirmationDataModel.getAllEntitiesAsStream().filter(this::isRelevantAndActive).sorted(this::compareTradeTimestamps).forEach(this::addData);
    }

    @Override
    public DataModelListener.NotificationResult notifyAdd(PublicTradeConfirmation object) {
        if (this.isRelevantAndActive(object)) {
            this.addData(object);
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemove(PublicTradeConfirmation object) {
        if (this.isRelevant(object)) {
            this.reloadChart();
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll(Collection<PublicTradeConfirmation> objects) {
        objects.stream().filter(this::isRelevant).findAny().ifPresent(confirmation -> this.reloadChart());
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdate(PublicTradeConfirmation object) {
        if (this.isRelevant(object)) {
            this.reloadChart();
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    ObservableValue<Number> minXValue() {
        return this.minXValue;
    }

    ObservableValue<Number> maxXValue() {
        return this.maxXValue;
    }

    private boolean isRelevantAndActive(PublicTradeConfirmation tradeConfirmation) {
        TradeState state = tradeConfirmation.getState();
        return this.isRelevant(tradeConfirmation) && (state.equals(TradeState.ACTIVE) || state.equals(TradeState.RECALL_REQUESTED) || state.equals(TradeState.RECALL_REJECTED) || state.equals(TradeState.CANCEL_REQUESTED) || state.equals(TradeState.CANCEL_REJECTED));
    }

    private boolean isRelevant(PublicTradeConfirmation tradeConfirmation) {
        return this.contract.equals(tradeConfirmation.getContract()) && this.displayFilter.test(tradeConfirmation) && (this.isAreaRelevant(tradeConfirmation.getBuyDeliveryArea()) || this.isAreaRelevant(tradeConfirmation.getSellDeliveryArea()));
    }

    private boolean isAreaRelevant(DeliveryArea deliveryArea) {
        return Optional.ofNullable(deliveryArea).map(DeliveryArea::getMarketArea).filter(this.marketArea::equals).isPresent();
    }

    XYChart.Series<Number, Number> asChartSeries() {
        return this.chartSeries;
    }

    private XYChart.Data<Number, Number> getData(PublicTradeConfirmation publicTradeConfirmation) {
        return new XYChart.Data<Number, Number>(publicTradeConfirmation.getTradeExecutionTime().getMillis(), this.tradeProperty.apply(publicTradeConfirmation).getValue());
    }

    private void addData(PublicTradeConfirmation publicTradeConfirmation) {
        XYChart.Data<Number, Number> dataPoint = this.getData(publicTradeConfirmation);
        Number xValue = dataPoint.getXValue();
        int index = this.findIndexForInsert(xValue);
        if (index == 0) {
            this.minXValue.setValue(xValue);
        }
        if (index == this.data.size()) {
            this.maxXValue.setValue(xValue);
        }
        if (this.aggregateValuesWithSameTimestamp && index < this.data.size() && ((Number)((XYChart.Data)this.data.get(index)).getXValue()).equals(xValue)) {
            this.mergeData(index, dataPoint);
        } else {
            this.data.add(index, dataPoint);
        }
    }

    private int findIndexForInsert(Number xValue) {
        int index;
        for (index = 0; index < this.data.size() && this.continueToNext(xValue, index); ++index) {
        }
        return index;
    }

    private boolean continueToNext(Number xValue, int index) {
        return this.aggregateValuesWithSameTimestamp ? ((Number)((XYChart.Data)this.data.get(index)).getXValue()).longValue() < xValue.longValue() : ((Number)((XYChart.Data)this.data.get(index)).getXValue()).longValue() <= xValue.longValue();
    }

    private void mergeData(int index, XYChart.Data<Number, Number> newDataPoint) {
        ((XYChart.Data)this.data.get(index)).setYValue(((Number)((XYChart.Data)this.data.get(index)).getYValue()).longValue() + newDataPoint.getYValue().longValue());
    }

    private int compareTradeTimestamps(PublicTradeConfirmation o1, PublicTradeConfirmation o2) {
        return o1.getTradeExecutionTime().compareTo(o2.getTradeExecutionTime());
    }
}

