/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesService;
import com.deutscheboerse.ui.jfx.util.control.ArrowKeyBlockingChoiceBox;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.util.converter.DefaultStringConverter;

public class AccountTypeChoiceBox
extends ArrowKeyBlockingChoiceBox<String> {
    private final OrderPreferencesService orderPreferencesService;
    private final ObservableValue<Exchange> activeExchange;
    private final ChangeListener<Exchange> activeExchangeChangeListener;

    public AccountTypeChoiceBox() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public AccountTypeChoiceBox(ApplicationContext appContext) {
        super(new DefaultStringConverter());
        this.orderPreferencesService = appContext.getService(OrderPreferencesService.class);
        this.activeExchange = appContext.getService(ActiveExchange.class).getActiveExchange();
        this.activeExchangeChangeListener = this::activeExchangeChanged;
        this.activeExchange.addListener(new WeakChangeListener<Exchange>(this.activeExchangeChangeListener));
        this.activeExchangeChanged(this.activeExchange, null, this.activeExchange.getValue());
        this.reset();
    }

    private void activeExchangeChanged(ObservableValue<? extends Exchange> observable2, Exchange oldValue, Exchange newValue) {
        if (newValue != null) {
            this.setListedItems(newValue.getSystemInfo().getAllowedClearingAccountTypes());
        }
    }

    public void reset() {
        this.setValue(this.orderPreferencesService.getDefaultAccount());
    }
}

