/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.jfx.components.aware.label.LabelKeyAwareTextField;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;

public class DecimalTextField
extends LabelKeyAwareTextField {
    private SimpleIntegerProperty maxDecimals = new SimpleIntegerProperty(3);
    private final TextFormatter<Optional<LongDisplayValue>> textFormatter;

    public DecimalTextField() {
        UnaryOperator filter = c -> this.parseLocalizedDecimal(c.getControlNewText()).isPresent() ? c : null;
        StringConverter<Optional<LongDisplayValue>> converter = new StringConverter<Optional<LongDisplayValue>>(){

            @Override
            public String toString(Optional<LongDisplayValue> object) {
                return object.map(Object::toString).orElse("");
            }

            @Override
            public Optional<LongDisplayValue> fromString(String string) {
                return DecimalTextField.this.parseLocalizedDecimal(string).map(LongDisplayValue::new).map(val -> val.applyShift(DecimalTextField.this.maxDecimals.get()));
            }
        };
        this.textFormatter = new TextFormatter(converter, Optional.empty(), filter);
        this.setTextFormatter(this.textFormatter);
    }

    @Override
    public void clear() {
        this.textFormatter.setValue(Optional.empty());
        super.clear();
    }

    public int getMaxDecimals() {
        return this.maxDecimals.get();
    }

    public SimpleIntegerProperty maxDecimalsProperty() {
        return this.maxDecimals;
    }

    public void setMaxDecimals(int maxDecimals) {
        this.maxDecimals.set(maxDecimals);
    }

    public Optional<LongDisplayValue> getValue() {
        return this.textFormatter.getValue();
    }

    private Optional<BigDecimal> parseLocalizedDecimal(String text) {
        try {
            return Optional.of(Util.parse(text)).filter(bd -> bd.scale() <= this.maxDecimals.get());
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }
}

