/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ContractDependentChoiceBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class OrderRestrictionChoiceBox
extends ContractDependentChoiceBox<ExecutionRestriction> {
    private static final Set<ExecutionRestriction> NONE_ITEM = EnumSet.of(ExecutionRestriction.NONE);
    private static final Set<ExecutionRestriction> AON_ITEMS = EnumSet.of(ExecutionRestriction.ALL_OR_NOTHING, ExecutionRestriction.FILL_OR_KILL, ExecutionRestriction.IMMEDIATE_OR_CANCEL);
    private static final Set<ExecutionRestriction> PARTIAL_EXE_ITEMS = EnumSet.of(ExecutionRestriction.NONE, ExecutionRestriction.FILL_OR_KILL, ExecutionRestriction.IMMEDIATE_OR_CANCEL);
    private static final Set<ExecutionRestriction> UDB_BLOCK_ITEMS = EnumSet.of(ExecutionRestriction.ALL_OR_NOTHING, ExecutionRestriction.IMMEDIATE_OR_CANCEL);
    private final ObjectProperty<OrderType> orderType = new SimpleObjectProperty<OrderType>(OrderType.REGULAR);
    private final ObservableValue<Exchange> exchange;
    private final InvalidationListener invalidationListener;

    public OrderRestrictionChoiceBox() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public OrderRestrictionChoiceBox(ApplicationContext appContext) {
        this.exchange = appContext.getService(ActiveExchange.class).getActiveExchange();
        this.setItems(EnumSet.allOf(ExecutionRestriction.class), ExecutionRestriction.NONE);
        this.invalidationListener = observable2 -> this.refresh();
        this.auctionContractProperty().addListener(this.invalidationListener);
        this.orderType.addListener(this.invalidationListener);
        this.exchange.addListener(new WeakInvalidationListener(this.invalidationListener));
    }

    @Override
    public void refresh() {
        this.setItems(new ArrayList<ExecutionRestriction>(this.computeListedItems()), this.computeDefaultValue());
    }

    private ExecutionRestriction computeDefaultValue() {
        if (!this.isExecutionRestrictionDeactivated() && this.getContractType() != null && this.getContractType().isBlock()) {
            return ExecutionRestriction.ALL_OR_NOTHING;
        }
        return ExecutionRestriction.NONE;
    }

    private Set<ExecutionRestriction> computeListedItems() {
        if (this.isExecutionRestrictionDeactivated()) {
            return NONE_ITEM;
        }
        if (this.isUDBContract()) {
            return UDB_BLOCK_ITEMS;
        }
        if (this.isAllOrNothingProduct()) {
            return AON_ITEMS;
        }
        if (this.isPartialExecutionProduct()) {
            return PARTIAL_EXE_ITEMS;
        }
        return NONE_ITEM;
    }

    private boolean isUDBContract() {
        return this.getContractType() != null && this.getContractType() == ContractType.UDB;
    }

    private boolean isPartialExecutionProduct() {
        return this.getContract() != null && this.getContract().getProduct().getExecutionRestriction() == ProductExecutionRestriction.PARTIAL_EXECUTION;
    }

    private boolean isAllOrNothingProduct() {
        return this.getContract() != null && this.getContract().getProduct().getExecutionRestriction() == ProductExecutionRestriction.ALL_OR_NOTHING;
    }

    private boolean isExecutionRestrictionDeactivated() {
        return this.orderType.get() == OrderType.OTC_PREARRANGED || this.orderType.get() == OrderType.ICEBERG || this.orderType.get() == OrderType.STOP;
    }

    private void setItems(Collection<ExecutionRestriction> items, ExecutionRestriction defaultValue) {
        ExecutionRestriction oldValue = (ExecutionRestriction)this.getValue();
        this.setListedItems(items);
        if (items.contains(oldValue)) {
            this.setValue(oldValue);
        } else {
            this.setValue(defaultValue);
        }
    }

    public OrderType getOrderType() {
        return (OrderType)this.orderType.get();
    }

    public ObjectProperty<OrderType> orderTypeProperty() {
        return this.orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType.set(orderType);
    }
}

