/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageType;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ButtonWithIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.FadeoutMessage;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.AllEntitiesProvider;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.FilteredTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.message.MessageAppender;
import com.deutscheboerse.comxerv.comtrader.jfx.components.message.MessageTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.EditEvent;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.StyleService;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.stage.Popup;
import javafx.stage.Window;

public class StatusBarMessagePanel
extends HBox
implements Destroyable,
BottomToolbarNode {
    private static final double PREF_WIDTH_TABLE = 700.0;
    private static final double PREF_HEIGHT_TABLE = 300.0;
    private final MessageListChangeListener listChangeListener;
    @FXML
    private FadeoutMessage fadeoutMessage;
    @FXML
    private ButtonWithIcon messageButton;
    private final MessageTableView messageTableView;
    private final Popup popup;
    private final ApplicationContext appContext = FXMLLoaderWithContext.getAppContext();
    private final FilteredTableView<Message> filteredTableView;

    public StatusBarMessagePanel() {
        this.messageTableView = new MessageTableView();
        this.popup = new Popup();
        this.popup.getContent().add(this.messageTableView);
        this.popup.setAutoHide(true);
        this.popup.setConsumeAutoHidingEvents(false);
        this.popup.setAutoFix(true);
        this.popup.setHideOnEscape(true);
        this.appContext.getService(StyleService.class).registerWindowForStyleSwitching(this.popup);
        this.messageTableView.setPrefWidth(700.0);
        this.messageTableView.setMinWidth(700.0);
        this.messageTableView.setPrefHeight(300.0);
        this.messageTableView.setMinHeight(300.0);
        int maxMessages = this.appContext.getService(ApplicationConfigurationService.class).getIntegerApplicationProperty("max.visible.messages", 1000);
        MessageAppender messageAppender = new MessageAppender(maxMessages, this.messageTableView.getItems());
        AllEntitiesProvider messageAllEntitiesProvider = new AllEntitiesProvider(this.appContext.getSmallDataModel(Message.class));
        this.filteredTableView = new FilteredTableView<Message>(this.messageTableView, m -> true, messageAllEntitiesProvider, messageAppender, true);
        this.appContext.getService(EventBus.class).register(this);
        FXMLLoaderWithContext.loadCustomComponent(this.appContext, this);
        this.listChangeListener = new MessageListChangeListener();
        this.messageTableView.getItems().addListener(this.listChangeListener);
        Tooltip.install(this.messageButton, new Tooltip(this.getDescription()));
    }

    @Override
    public void destroy() {
        this.appContext.getService(EventBus.class).unregister(this);
    }

    @Subscribe
    public void handleEditMode(EditEvent editEvent) {
        if (editEvent.isEditMode()) {
            this.listChangeListener.suspend();
            this.fadeoutMessage.showMessage(Util.getLabel("feedback_message_editMode"));
        } else {
            this.listChangeListener.resume();
            this.fadeoutMessage.showMessage("");
        }
    }

    @FXML
    public void showPopUp() {
        if (!this.popup.isShowing()) {
            Point2D p = this.localToScene(0.0, 0.0);
            Scene scene = this.getScene();
            if (scene != null) {
                Window window = scene.getWindow();
                double x = p.getX() + scene.getX() + window.getX();
                double y = p.getY() + scene.getY() + window.getY() - 300.0;
                this.popup.show(this, x, y);
            }
        } else {
            this.popup.hide();
        }
    }

    @Override
    public Node getPreviewForConfigTable() {
        ButtonWithIcon preview = new ButtonWithIcon("", "button-open-message-popup");
        preview.setDisable(true);
        return preview;
    }

    @Override
    public String getDescription() {
        return Util.getLabel("descriptions_toolbar_mainPanel_massages");
    }

    private final class MessageListChangeListener
    implements ListChangeListener<Message> {
        private Message lastMessage = null;
        private boolean suspended = false;

        private MessageListChangeListener() {
        }

        @Override
        public void onChanged(ListChangeListener.Change<? extends Message> change) {
            Optional<Message> newMessage = StatusBarMessagePanel.this.messageTableView.getItems().stream().filter(message -> MessageType.PRIVATE.equals(message.getType()) || MessageType.GUI.equals(message.getType())).findFirst();
            if (!this.suspended && newMessage.isPresent() && !newMessage.get().equals(this.lastMessage)) {
                this.lastMessage = newMessage.get();
                FxUtil.runInFxThread(() -> StatusBarMessagePanel.this.fadeoutMessage.showMessage((Message)newMessage.get()));
            }
        }

        private void suspend() {
            this.suspended = true;
        }

        private void resume() {
            this.suspended = false;
        }
    }
}

