/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter;

import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.FilterValueField;
import com.deutscheboerse.ui.jfx.util.binding.ValidProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.control.TextField;

public class IntegerFilterValueField
extends FilterValueField<String> {
    private final ObjectProperty<String> value;
    private final TextField textField = new TextField();
    private final ValidProperty valid = new ValidProperty(this.textField);

    public IntegerFilterValueField() {
        this.value = new SimpleObjectProperty<String>();
        this.valid.set(false);
        this.textField.textProperty().addListener((observable2, oldValue, newValue) -> this.setIntegerValue((String)newValue));
        this.textField.setAlignment(Pos.CENTER_LEFT);
        this.setCenter(this.textField);
    }

    @Override
    public ReadOnlyBooleanProperty validProperty() {
        return this.valid;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }

    @Override
    public String getValue() {
        return (String)this.value.get();
    }

    @Override
    public void setValue(String value) {
        this.setIntegerValue(value);
        this.textField.setText(value);
    }

    private void setIntegerValue(String value) {
        try {
            if (value != null) {
                Integer.valueOf(value);
                this.value.setValue(value);
            } else {
                this.value.setValue(null);
            }
            this.valid.set(true);
        }
        catch (NumberFormatException e) {
            this.value.setValue(null);
            this.valid.set(false);
        }
    }
}

