/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.eula;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ButtonWithIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.eula.EulaTab;
import com.deutscheboerse.comxerv.comtrader.jfx.util.UtilityStages;
import com.deutscheboerse.comxerv.comtrader.service.EulaService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.ConstantObservableValue;
import com.deutscheboerse.ui.jfx.util.binding.DependentObservableValue;
import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class EulaPanel
extends BorderPane
implements EulaService.EulaUi {
    private final ApplicationContext applicationContext;
    @FXML
    private TabPane tabPane;
    @FXML
    private ButtonWithIcon agreeButton;
    private final Stage stage;
    private Consumer<Optional<EulaService.Eula>> acceptedEula;

    @Inject
    protected EulaPanel(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        FXMLLoaderWithContext.loadCustomComponent(applicationContext, this);
        this.stage = applicationContext.getService(UtilityStages.class).withKey(EulaPanel.class.getName()).withModality(Modality.APPLICATION_MODAL).withRoot(this).get();
        this.bindAgreeButtonProperties();
    }

    private void bindAgreeButtonProperties() {
        ReadOnlyObjectProperty selectedTab = this.tabPane.getSelectionModel().selectedItemProperty();
        this.agreeButton.disableProperty().bind(DependentObservableValue.get(selectedTab, this::shouldAgreeButtonBeDisabled, true, new Observable[0]));
        this.agreeButton.textProperty().bind(DependentObservableValue.get(selectedTab, this::getAgreeButtonText, "", new Observable[0]));
        DependentObservableValue.get(selectedTab, this::getAgreeButtonIcon, "", new Observable[0]).addListener((observable2, oldValue, newValue) -> this.agreeButton.setIconStyleClass((String)newValue));
    }

    private ObservableValue<String> getAgreeButtonText(Tab tab) {
        return tab instanceof EulaTab ? Bindings.when(((EulaTab)tab).canPageDownProperty()).then(Util.getLabel("commons_next")).otherwise(Util.getLabel("commons_agree")) : ConstantObservableValue.EMPTY_STRING;
    }

    private ObservableValue<String> getAgreeButtonIcon(Tab tab) {
        return tab instanceof EulaTab ? Bindings.when(((EulaTab)tab).canPageDownProperty()).then("icon-arrow-down").otherwise("button-ok") : ConstantObservableValue.EMPTY_STRING;
    }

    private ObservableValue<Boolean> shouldAgreeButtonBeDisabled(Tab tab) {
        return tab instanceof EulaTab ? ((EulaTab)tab).finishedLoadingProperty().not() : ConstantObservableValue.TRUE;
    }

    @Override
    public void show(List<EulaService.Eula> eulas, Consumer<Optional<EulaService.Eula>> acceptedEula) {
        this.acceptedEula = acceptedEula;
        eulas.stream().map(eula -> new EulaTab(this.applicationContext, (EulaService.Eula)eula)).forEach(this.tabPane.getTabs()::add);
        this.stage.show();
    }

    public void agree() {
        Tab selectedTab = (Tab)this.tabPane.getSelectionModel().getSelectedItem();
        if (selectedTab instanceof EulaTab) {
            EulaTab eulaTab = (EulaTab)selectedTab;
            if (eulaTab.canPageDown()) {
                eulaTab.pageDown();
            } else {
                this.stage.hide();
                this.acceptedEula.accept(Optional.of(eulaTab.getEula()));
            }
        }
    }

    public void disagree() {
        this.stage.hide();
        this.acceptedEula.accept(Optional.empty());
    }
}

