/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter;

import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.AndTableFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.BulkAppender;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ColumnFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.EmptyFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.PredicateType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.RelevantEntitiesProvider;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.SortingTableItemsAppender;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.TableColumnFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.TableFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.column.FilterableTableColumn;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.state.ColumnFilterState;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.ObservableBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableView;

public class FilteredTableView<S extends BroadcastEntity>
extends ObservableBase
implements DataModelListener<S> {
    private final TableView<S> tableView;
    private final RelevantEntitiesProvider<S> relevantEntitiesProvider;
    private final Consumer<S> tableItemsAppender;
    private final ObjectProperty<Integer> totalItemsCount;
    private final ObservableValue<Integer> shownItemsCount;
    private final Set<S> totalItems;
    private final Set<S> visibleItems;
    private final ObjectProperty<TableFilter<S>> customFilter;
    private Predicate<S> baseFilter;
    private Predicate<S> quickFilter;

    public FilteredTableView(TableView<S> tableView, Predicate<S> baseFilter, RelevantEntitiesProvider<S> relevantEntitiesProvider, boolean registerDataModelListener) {
        this(tableView, baseFilter, relevantEntitiesProvider, new SortingTableItemsAppender<S>(tableView), registerDataModelListener);
    }

    public FilteredTableView(TableView<S> tableView, Predicate<S> baseFilter, RelevantEntitiesProvider<S> relevantEntitiesProvider, Consumer<S> tableItemsAppender, boolean registerDataModelListener) {
        this.shownItemsCount = DependentBinding.get(tableView.getItems()::size, tableView.getItems());
        this.totalItemsCount = new SimpleObjectProperty<Integer>(0);
        this.totalItems = new HashSet<S>();
        this.visibleItems = new HashSet<S>();
        this.tableItemsAppender = tableItemsAppender;
        this.tableView = tableView;
        this.baseFilter = baseFilter;
        this.relevantEntitiesProvider = relevantEntitiesProvider;
        this.quickFilter = new EmptyFilter();
        this.customFilter = new SimpleObjectProperty(new EmptyFilter());
        this.customFilter.addListener((ObservableValue<? super T> observable2, ? super T oldValue, ? super T newValue) -> this.customFilterChanged((TableFilter<S>)newValue));
        if (registerDataModelListener) {
            this.relevantEntitiesProvider.registerDataModelListener(this);
        }
    }

    public List<FilterableTableColumn<S, ?, ? extends Serializable>> getFilterableTableColumns() {
        List<FilterableTableColumn<S, ?, ? extends Serializable>> list = this.tableView.getColumns().stream().filter(FilterableTableColumn.class::isInstance).map(column -> (FilterableTableColumn)column).toList();
        return list;
    }

    public TableFilter<S> getCustomFilter() {
        return (TableFilter)this.customFilter.get();
    }

    public void setCustomFilter(TableFilter<S> customFilter) {
        this.customFilter.setValue(customFilter);
    }

    private void customFilterChanged(TableFilter<S> newCustomFilter) {
        this.refilter();
        this.showFilterIcons();
    }

    public ReadOnlyObjectProperty<TableFilter<S>> customFilterProperty() {
        return this.customFilter;
    }

    public void loadCustomFilter(List<ColumnFilterState<?>> storedState) {
        ArrayList loadedFilters = new ArrayList(storedState.size());
        for (ColumnFilterState<?> state : storedState) {
            Optional<FilterableTableColumn> matchingTableColumn = this.getFilterableTableColumns().stream().filter(column -> state.getColumnId().equals(column.getId())).findFirst();
            if (!matchingTableColumn.isPresent()) continue;
            FilterableTableColumn filterableTableColumn = matchingTableColumn.get();
            Object filterValue = state.getValue();
            loadedFilters.add(this.getTableFilter(filterableTableColumn, state.getPredicateType(), (Serializable)filterValue));
        }
        this.setCustomFilter(new AndTableFilter(loadedFilters));
    }

    private <T, F extends Serializable> TableFilter<S> getTableFilter(FilterableTableColumn<S, T, F> filterableTableColumn, PredicateType predicateType, F filterValue) {
        ColumnFilter<T, F> columnFilter = filterableTableColumn.getColumnFilter();
        return new TableColumnFilter<S, T, F>(filterableTableColumn, filterValue, columnFilter, predicateType);
    }

    private void showFilterIcons() {
        this.getFilterableTableColumns().forEach(column -> column.displayFilterIcon(((TableFilter)this.customFilter.get()).getFilteredColumns().contains(column)));
    }

    public Predicate<S> getQuickFilter() {
        return this.quickFilter;
    }

    public void setQuickFilter(Predicate<S> quickFilter) {
        if (!quickFilter.equals(this.quickFilter)) {
            this.quickFilter = quickFilter;
            this.refilter();
        }
    }

    public void setBaseFilter(Predicate<S> baseFilter) {
        if (!baseFilter.equals(this.baseFilter)) {
            this.baseFilter = baseFilter;
            this.refilter();
        }
    }

    private void refilter() {
        this.removeAll();
        this.addAll(this.relevantEntitiesProvider::getRelevantEntities);
    }

    @Override
    public DataModelListener.NotificationResult notifyAdd(S object) {
        this.add(object);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    protected void add(S object) {
        if (this.baseFilter.test(object)) {
            this.totalItems.add(object);
            this.updateTotalItems();
        }
        if (this.matchesFilters(object) && this.addVisibleItem(object)) {
            this.tableItemsAppender.accept(object);
            this.invalidate();
        }
    }

    protected void addAll(Supplier<Stream<S>> streamSupplier) {
        streamSupplier.get().filter(this.baseFilter).forEach(this.totalItems::add);
        this.updateTotalItems();
        Stream<BroadcastEntity> stream = streamSupplier.get().filter(this::matchesFilters).filter(this::addVisibleItem);
        Consumer<S> consumer = this.tableItemsAppender;
        if (consumer instanceof BulkAppender) {
            BulkAppender bulkAppender = (BulkAppender)((Object)consumer);
            bulkAppender.bulkAppend(stream.toList());
        } else {
            stream.forEach(this.tableItemsAppender);
        }
        this.invalidate();
    }

    private void remove(S object) {
        this.totalItems.remove(object);
        this.updateTotalItems();
        if (this.removeVisibleItem(object)) {
            this.tableView.getItems().remove(object);
        }
        this.invalidate();
    }

    private void removeAll(Collection<S> collection) {
        this.totalItems.removeAll(collection);
        this.updateTotalItems();
        if (this.removeVisibleItems(collection)) {
            this.tableView.getItems().removeAll(collection);
            this.invalidate();
        }
    }

    private void removeAll() {
        this.totalItems.clear();
        this.updateTotalItems();
        this.clearVisibleItems();
        this.tableView.getItems().clear();
        this.invalidate();
    }

    private boolean matchesFilters(S object) {
        return this.baseFilter.test(object) && this.quickFilter.test(object) && ((TableFilter)this.customFilter.get()).test(object);
    }

    @Override
    public DataModelListener.NotificationResult notifyAddAll(Collection<S> objects) {
        this.addAll(objects::stream);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemove(S object) {
        this.remove(object);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll(Collection<S> objects) {
        this.removeAll(objects);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll() {
        this.removeAll();
        return DataModelListener.NotificationResult.REMOVE_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdate(S object) {
        if (this.baseFilter.test(object)) {
            this.totalItems.add(object);
            this.updateTotalItems();
            if (this.matchesFilters(object)) {
                if (this.addVisibleItem(object)) {
                    this.tableItemsAppender.accept(object);
                }
            } else if (this.removeVisibleItem(object)) {
                this.tableView.getItems().remove(object);
            }
        } else {
            this.totalItems.remove(object);
            this.updateTotalItems();
            if (this.removeVisibleItem(object)) {
                this.tableView.getItems().remove(object);
            }
        }
        this.invalidate();
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdateAll(Collection<S> objects) {
        List<BroadcastEntity> objectToAddToTable;
        HashSet<BroadcastEntity> objectsToAdd = new HashSet<BroadcastEntity>();
        HashSet<BroadcastEntity> objectsToRemove = new HashSet<BroadcastEntity>();
        for (BroadcastEntity object : objects) {
            if (this.baseFilter.test(object)) {
                this.totalItems.add(object);
                if (this.matchesFilters(object)) {
                    objectsToAdd.add(object);
                    continue;
                }
                objectsToRemove.add(object);
                continue;
            }
            this.totalItems.remove(object);
            objectsToRemove.add(object);
        }
        this.updateTotalItems();
        if (!objectsToRemove.isEmpty() && this.visibleItems.removeAll(objectsToRemove)) {
            this.tableView.getItems().removeAll((Collection<?>)objectsToRemove);
        }
        if (!(objectToAddToTable = objectsToAdd.stream().filter(this::addVisibleItem).toList()).isEmpty()) {
            Consumer<S> consumer = this.tableItemsAppender;
            if (consumer instanceof BulkAppender) {
                BulkAppender bulkAppender = (BulkAppender)((Object)consumer);
                bulkAppender.bulkAppend(objectToAddToTable);
            } else {
                objectToAddToTable.forEach(this.tableItemsAppender);
            }
        }
        this.invalidate();
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    protected boolean contains(Predicate<S> filter) {
        return ((Stream)this.totalItems.stream().parallel()).anyMatch(filter);
    }

    protected void removeIf(Predicate<S> filter) {
        this.notifyRemoveAll(this.totalItems.stream().filter(filter).collect(Collectors.toSet()));
    }

    private void updateTotalItems() {
        this.totalItemsCount.setValue(this.totalItems.size());
    }

    public ObservableValue<Integer> totalItems() {
        return this.totalItemsCount;
    }

    public ObservableValue<Integer> shownItems() {
        return this.shownItemsCount;
    }

    protected boolean addVisibleItem(S item) {
        return this.visibleItems.add(item);
    }

    protected boolean removeVisibleItem(S item) {
        return this.visibleItems.remove(item);
    }

    protected boolean removeVisibleItems(Collection<S> items) {
        return this.visibleItems.removeAll(items);
    }

    protected void clearVisibleItems() {
        this.visibleItems.clear();
    }
}

