/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ColumnFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.PredicateType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.TableFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.column.FilterableTableColumn;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.state.ColumnFilterState;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

public class TableColumnFilter<S extends BroadcastEntity, T, F extends Serializable>
implements TableFilter<S> {
    private final FilterableTableColumn<S, T, F> tableColumn;
    private final F filterValue;
    private final ColumnFilter<T, F> columnFilter;
    private final PredicateType predicateType;

    public TableColumnFilter(FilterableTableColumn<S, T, F> tableColumn, F filterValue, ColumnFilter<T, F> columnFilter, PredicateType predicateType) {
        this.tableColumn = tableColumn;
        this.filterValue = filterValue;
        this.columnFilter = columnFilter;
        this.predicateType = predicateType;
    }

    @Override
    public Collection<FilterableTableColumn<S, ?, ?>> getFilteredColumns() {
        return Collections.singleton(this.tableColumn);
    }

    @Override
    public boolean test(S s) {
        Object cellValue = this.tableColumn.getCellData(s);
        return this.columnFilter.matches(this.predicateType, cellValue, this.filterValue);
    }

    @Override
    public Collection<ColumnFilterState<?>> getFilterStates() {
        return Collections.singletonList(new ColumnFilterState<F>(this.filterValue, this.predicateType, this.tableColumn.getId()));
    }
}

