/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter.column;

import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.FilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.LongFilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ColumnFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.PredicateType;
import com.google.common.collect.Lists;
import java.util.List;

public class LongColumnFilter
implements ColumnFilter<Long, String> {
    @Override
    public List<PredicateType> getPredicateTypes() {
        return Lists.newArrayList(PredicateType.EQUAL, PredicateType.NOT_EQUAL, PredicateType.LOWER, PredicateType.LOWER_EQUAL, PredicateType.GREATER, PredicateType.GREATER_EQUAL, PredicateType.SUBSTRING, PredicateType.NOT_SUBSTRING, PredicateType.IS_EMPTY, PredicateType.IS_NOT_EMPTY);
    }

    @Override
    public FilterValueField<String> getValueField(PredicateType predicateType) {
        return predicateType == PredicateType.IS_EMPTY || predicateType == PredicateType.IS_NOT_EMPTY ? null : new LongFilterValueField();
    }

    @Override
    public boolean matches(PredicateType predicateType, Long cellValue, String filterValue) {
        switch (predicateType) {
            case EQUAL: {
                return cellValue != null && filterValue != null && cellValue.compareTo(Long.valueOf(filterValue)) == 0;
            }
            case NOT_EQUAL: {
                return !this.matches(PredicateType.EQUAL, cellValue, filterValue);
            }
            case LOWER: {
                return cellValue != null && filterValue != null && cellValue.compareTo(Long.valueOf(filterValue)) < 0;
            }
            case LOWER_EQUAL: {
                return cellValue != null && filterValue != null && cellValue.compareTo(Long.valueOf(filterValue)) <= 0;
            }
            case GREATER: {
                return cellValue != null && filterValue != null && cellValue.compareTo(Long.valueOf(filterValue)) > 0;
            }
            case GREATER_EQUAL: {
                return cellValue != null && filterValue != null && cellValue.compareTo(Long.valueOf(filterValue)) >= 0;
            }
            case SUBSTRING: {
                return cellValue != null && filterValue != null && cellValue.toString().toLowerCase().contains(filterValue.toLowerCase());
            }
            case NOT_SUBSTRING: {
                return !this.matches(PredicateType.SUBSTRING, cellValue, filterValue);
            }
            case IS_EMPTY: {
                return cellValue == null;
            }
            case IS_NOT_EMPTY: {
                return cellValue != null;
            }
        }
        throw new IllegalArgumentException("Invalid predicate type");
    }
}

