/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter.column;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.FilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.LongDisplayValueFilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ColumnFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.PredicateType;
import com.google.common.collect.Lists;
import java.util.List;

public class LongDisplayValueColumnFilter
implements ColumnFilter<LongDisplayValue, LongDisplayValue> {
    @Override
    public List<PredicateType> getPredicateTypes() {
        return Lists.newArrayList(PredicateType.EQUAL, PredicateType.NOT_EQUAL, PredicateType.LOWER, PredicateType.LOWER_EQUAL, PredicateType.GREATER, PredicateType.GREATER_EQUAL, PredicateType.IS_EMPTY, PredicateType.IS_NOT_EMPTY);
    }

    @Override
    public FilterValueField<LongDisplayValue> getValueField(PredicateType predicateType) {
        return predicateType == PredicateType.IS_EMPTY || predicateType == PredicateType.IS_NOT_EMPTY ? null : new LongDisplayValueFilterValueField();
    }

    @Override
    public boolean matches(PredicateType predicateType, LongDisplayValue cellValue, LongDisplayValue filterValue) {
        switch (predicateType) {
            case EQUAL: {
                return cellValue == null && filterValue == null || cellValue != null && filterValue != null && cellValue.compareTo(filterValue) == 0;
            }
            case NOT_EQUAL: {
                return !this.matches(PredicateType.EQUAL, cellValue, filterValue);
            }
            case LOWER: {
                return cellValue != null && filterValue != null && cellValue.compareTo(filterValue) < 0;
            }
            case LOWER_EQUAL: {
                return cellValue != null && filterValue != null && cellValue.compareTo(filterValue) <= 0;
            }
            case GREATER: {
                return cellValue != null && filterValue != null && cellValue.compareTo(filterValue) > 0;
            }
            case GREATER_EQUAL: {
                return cellValue != null && filterValue != null && cellValue.compareTo(filterValue) >= 0;
            }
            case IS_EMPTY: {
                return cellValue == null;
            }
            case IS_NOT_EMPTY: {
                return cellValue != null;
            }
        }
        throw new IllegalArgumentException("Invalid predicate type");
    }
}

