/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.layout;

import com.deutscheboerse.comxerv.comtrader.jfx.components.ContentTab;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import javafx.collections.ObservableList;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;

public class ContentTabContextMenu
extends ContextMenu {
    private final ContentTab contentTab;
    private final MenuItem setTitle = new MenuItem(Util.getLabel("contentTab_setTitle"));
    private final MenuItem close = new MenuItem(Util.getLabel("commons_closeTab"));
    private final MenuItem openInNewWindow = new MenuItem(Util.getLabel("contentTab_openInNewWindow"));
    private final MenuItem moveTabRight = new MenuItem(Util.getLabel("contentTab_moveTabRight"));
    private final MenuItem moveTabLeft = new MenuItem(Util.getLabel("contentTab_moveTabLeft"));

    public ContentTabContextMenu(ContentTab contentTab) {
        this.contentTab = contentTab;
        this.addSetTitleMenuItem();
        this.addMenuSeparator();
        this.addOpenInNewWindowMenuItem();
        this.addCloseMenuItem();
        this.addMenuSeparator();
        this.addMoveTabRight();
        this.addMoveTabLeft();
        this.setOnShowing(event -> this.disableMenuItems());
    }

    private void disableMenuItems() {
        ObservableList<Tab> tabs = this.contentTab.getTabPane().getTabs();
        int index = tabs.indexOf(this.contentTab);
        int tabsSize = tabs.size();
        this.openInNewWindow.setDisable(tabsSize < 2);
        this.moveTabLeft.setDisable(index < 1);
        this.moveTabRight.setDisable(index < 0 || index > tabsSize - 3);
    }

    private void addSetTitleMenuItem() {
        this.getItems().add(this.setTitle);
        this.setTitle.setOnAction(event -> this.contentTab.editName());
    }

    private void addOpenInNewWindowMenuItem() {
        this.getItems().add(this.openInNewWindow);
        this.openInNewWindow.setOnAction(event -> this.contentTab.openInNewWindow());
    }

    private void addCloseMenuItem() {
        this.getItems().add(this.close);
        this.close.setOnAction(event -> this.contentTab.close());
    }

    private void addMoveTabRight() {
        this.getItems().add(this.moveTabRight);
        this.moveTabRight.setOnAction(event -> this.contentTab.moveRight());
    }

    private void addMoveTabLeft() {
        this.getItems().add(this.moveTabLeft);
        this.moveTabLeft.setOnAction(event -> this.contentTab.moveLeft());
    }

    private void addMenuSeparator() {
        this.getItems().add(new SeparatorMenuItem());
    }
}

