/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.market;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.market.AbstractMarketOrderWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.market.MarketSubmitter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.market.OwnMarketSubmitter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OrderbookRemovalCallback;
import java.util.Optional;

public class BestOwnOrderWrapper
extends AbstractMarketOrderWrapper {
    private final OwnMarketSubmitter ownMarketSubmitter;
    private final OrderQueries orderQueries;

    public BestOwnOrderWrapper(Orderbook wrapped, OrderbookRemovalCallback orderbookRemovalCallback, ApplicationContext appContext, ContractAdditionOrigin origin) {
        super(orderbookRemovalCallback, appContext, origin);
        this.ownMarketSubmitter = new OwnMarketSubmitter(appContext);
        this.orderQueries = appContext.getService(OrderQueries.class);
        this.setOrderbook(wrapped);
    }

    @Override
    public Optional<Order> getBestOwnBuyOrder() {
        return Optional.ofNullable(this.getOrderbook()).flatMap(orderbook -> this.orderQueries.findBestOrderForOrderbook((Orderbook)orderbook, Direction.BUY));
    }

    @Override
    public Optional<Order> getBestOwnSellOrder() {
        return Optional.ofNullable(this.getOrderbook()).flatMap(orderbook -> this.orderQueries.findBestOrderForOrderbook((Orderbook)orderbook, Direction.SELL));
    }

    @Override
    protected MarketSubmitter getMarketSubmitter() {
        return this.ownMarketSubmitter;
    }
}

