/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.LimitlessPriceField;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import javafx.beans.Observable;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;

public class StopPriceField
extends LimitlessPriceField {
    private final SimpleObjectProperty<LongDisplayValue> limitPrice = new SimpleObjectProperty();
    private final SimpleObjectProperty<Direction> direction = new SimpleObjectProperty();

    public StopPriceField() {
    }

    public StopPriceField(LongDisplayValue initialValue) {
        super(initialValue);
    }

    public StopPriceField(LongDisplayValue initialValue, int delta) {
        super(initialValue, delta);
    }

    public void init(final ObservableObjectValue<Contract> contract, ObservableObjectValue<OrderType> orderType) {
        super.init(contract);
        orderType.addListener((observableValue, oldValue, newValue) -> {
            if (newValue != OrderType.STOP) {
                this.setValue(null);
            }
        });
        this.minimumProperty().bind((ObservableValue<LongDisplayValue>)new DependentBinding<LongDisplayValue>(new Observable[]{contract, this.limitPrice, this.direction}){

            @Override
            protected LongDisplayValue computeValue() {
                if (contract.get() != null) {
                    return StopPriceField.this.direction.get() == Direction.SELL ? (LongDisplayValue)StopPriceField.this.limitPrice.get() : ((Contract)contract.get()).getProduct().getPriceMinValue();
                }
                return LongDisplayValue.ZERO;
            }
        });
        this.maximumProperty().bind((ObservableValue<LongDisplayValue>)new DependentBinding<LongDisplayValue>(new Observable[]{contract, this.limitPrice, this.direction}){

            @Override
            protected LongDisplayValue computeValue() {
                if (contract.get() != null) {
                    return StopPriceField.this.direction.get() == Direction.BUY || contract.get() == null ? (LongDisplayValue)StopPriceField.this.limitPrice.get() : ((Contract)contract.get()).getProduct().getPriceMaxValue();
                }
                return new LongDisplayValue(Integer.MAX_VALUE, 0);
            }
        });
    }

    public LongDisplayValue getLimitPrice() {
        return (LongDisplayValue)this.limitPrice.get();
    }

    public SimpleObjectProperty<LongDisplayValue> limitPriceProperty() {
        return this.limitPrice;
    }

    public void setLimitPrice(LongDisplayValue limitPrice) {
        this.limitPrice.set(limitPrice);
    }

    public Direction getDirection() {
        return (Direction)this.direction.get();
    }

    public SimpleObjectProperty<Direction> directionProperty() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction.set(direction);
    }
}

