/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.contract;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.BlockContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.BlockProductField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ContractField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.contract.BlockContractField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.contract.ContractFieldWrapper;
import com.deutscheboerse.comxerv.comtrader.service.BlockContractService;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class BlockContractFieldWrapper
implements ContractFieldWrapper {
    private final ContractField frontContractField;
    private final ContractField rearContractField;
    private final BlockProductField blockProductField;
    private final ObjectProperty<Contract> value;
    private final BlockContractService blockContractService;
    private boolean changing;

    public BlockContractFieldWrapper(ApplicationContext appContext, BlockContractField frontContractField, BlockContractField rearContractField, BlockProductField blockProductField) {
        this.blockContractService = appContext.getService(BlockContractService.class);
        this.frontContractField = frontContractField;
        this.rearContractField = rearContractField;
        this.blockProductField = blockProductField;
        this.changing = false;
        rearContractField.disableProperty().bind(frontContractField.disabledProperty());
        blockProductField.disableProperty().bind(frontContractField.disabledProperty());
        frontContractField.otherProperty().bind(rearContractField.valueProperty());
        rearContractField.otherProperty().bind(frontContractField.valueProperty());
        frontContractField.blockProductProperty().bind(blockProductField.valueProperty());
        rearContractField.blockProductProperty().bind(blockProductField.valueProperty());
        this.value = new SimpleObjectProperty<Contract>();
        this.value.addListener(this::valueChanged);
        frontContractField.valueProperty().addListener(this::frontOrBackContractChanged);
        rearContractField.valueProperty().addListener(this::frontOrBackContractChanged);
        blockProductField.valueProperty().addListener(this::blockProductChanged);
        frontContractField.productProperty().bind(blockProductField.baseProductValueProperty());
        rearContractField.productProperty().bind(blockProductField.baseProductValueProperty());
        frontContractField.focusedProperty().addListener((observable2, oldValue, newValue) -> {
            if (frontContractField.getValue() != null && oldValue.booleanValue() && !newValue.booleanValue()) {
                Product product = this.blockContractService.getBlockProduct(((Contract)frontContractField.getValue()).getProduct());
                blockProductField.setText(product.getDisplayName());
            }
        });
        rearContractField.focusedProperty().addListener((observable2, oldValue, newValue) -> {
            if (rearContractField.getValue() != null && oldValue.booleanValue() && !newValue.booleanValue()) {
                Product product = this.blockContractService.getBlockProduct(((Contract)rearContractField.getValue()).getProduct());
                blockProductField.setText(product.getDisplayName());
            }
        });
    }

    @Override
    public boolean canHandleContract(Contract contract) {
        return contract instanceof BlockContract;
    }

    private void frontOrBackContractChanged(ObservableValue<? extends Contract> observable2, Contract oldValue, Contract newValue) {
        this.changing = true;
        this.value.setValue(this.getBlockContract());
        this.changing = false;
    }

    private void blockProductChanged(ObservableValue<? extends Product> observable2, Product oldValue, Product newValue) {
        this.changing = true;
        this.value.setValue(this.getBlockContract());
        this.changing = false;
    }

    private BlockContract getBlockContract() {
        Contract frontContract = (Contract)this.frontContractField.getValue();
        Contract rearContract = (Contract)this.rearContractField.getValue();
        Product product = (Product)this.blockProductField.getValue();
        if (frontContract != null && rearContract != null && product != null) {
            return this.blockContractService.createBlockContract(frontContract, rearContract, product).orElse(null);
        }
        return null;
    }

    private void valueChanged(ObservableValue<? extends Contract> observable2, Contract oldValue, Contract newValue) {
        if (!this.changing) {
            if (newValue instanceof BlockContract) {
                BlockContract blockContract = (BlockContract)newValue;
                String frontContractName = Optional.of(blockContract.getFrontContract()).map(Contract::getDisplayName).orElse("");
                String rearContractName = Optional.of(blockContract.getRearContract()).map(Contract::getDisplayName).orElse("");
                String blockProductName = Optional.of(blockContract.getProduct()).map(Product::getDisplayName).orElse("");
                this.blockProductField.setText(blockProductName);
                this.frontContractField.setText(frontContractName);
                this.rearContractField.setText(rearContractName);
            } else {
                this.frontContractField.setText("");
                this.rearContractField.setText("");
                this.blockProductField.setText("");
            }
        }
    }

    @Override
    public ObjectProperty<Contract> valueProperty() {
        return this.value;
    }

    @Override
    public BooleanProperty disabledProperty() {
        return this.frontContractField.disableProperty();
    }

    @Override
    public void reset() {
        this.frontContractField.setText("");
        this.rearContractField.setText("");
        this.blockProductField.setText("");
    }
}

