/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.settings;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.SettingsSection;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AllDescendantsByIdOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderQuoteNotificationService;
import com.deutscheboerse.comxerv.comtrader.service.trade.BespokeService;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;

@OverrideGuiConfiguration(field="#this", overrideId="ComXervSettingsPane", strategy=AllDescendantsByIdOverrideGuiStrategy.class)
public class ComXervSettingsPane
extends GridPane
implements SettingsSection {
    @FXML
    private Label orderRequestPopupLabel;
    @FXML
    private CheckBox orderRequestPopupCheckBox;
    @FXML
    private CheckBox bespokeTradeConfirmationPopupCheckBox;
    private final OrderQuoteNotificationService orderQuoteNotificationService;
    private final BespokeService bespokeService;

    public ComXervSettingsPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public ComXervSettingsPane(ApplicationContext appContext) {
        this.orderQuoteNotificationService = appContext.getService(OrderQuoteNotificationService.class);
        this.bespokeService = appContext.getService(BespokeService.class);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        appContext.getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(this);
    }

    @Override
    public boolean applyChanges() {
        this.orderQuoteNotificationService.setOrderQuotePopupEnabled(this.orderRequestPopupCheckBox.isSelected());
        this.bespokeService.setBespokeTradeConfirmationPopupEnabled(this.bespokeTradeConfirmationPopupCheckBox.isSelected());
        return true;
    }

    @Override
    public void cancelChanges() {
        this.orderRequestPopupCheckBox.setSelected(this.orderQuoteNotificationService.isOrderQuotePopupEnabled());
        this.bespokeTradeConfirmationPopupCheckBox.setSelected(this.bespokeService.isBespokeTradeConfirmationPopupEnabled());
    }

    @Override
    public void resetToDefault() {
        this.orderRequestPopupCheckBox.setSelected(false);
        this.bespokeTradeConfirmationPopupCheckBox.setSelected(false);
    }
}

