/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ValueChangeWidget;
import com.deutscheboerse.comxerv.comtrader.jfx.components.h2h.HubToHubRow;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.GeneralSettingsPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CapacityValue;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.GenericCellCustomizer;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import javafx.scene.Node;
import javafx.scene.control.TableCell;

public class CapacityValueCellCustomizer<O extends HubToHubRow>
extends GenericCellCustomizer<O, CapacityValue> {
    private final SettingsService settingsService;

    public CapacityValueCellCustomizer() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected CapacityValueCellCustomizer(ApplicationContext applicationContext) {
        this.settingsService = applicationContext.getService(SettingsService.class);
    }

    @Override
    protected String getText(CapacityValue cellItem, O rowValue, String defaultText) {
        if (cellItem != null && cellItem.getValue() != null) {
            return new LongDisplayValue(cellItem.getValue(), 3).toString();
        }
        return defaultText;
    }

    @Override
    protected Node getGraphic(CapacityValue cellItem, O rowValue, Node defaultGraphic) {
        boolean showIcon = cellItem != null && cellItem.getValue() != null && cellItem.getPriceChange() != null;
        return showIcon ? new ValueChangeWidget(cellItem.getPriceChange()) : null;
    }

    @Override
    protected void customizeTableCell(TableCell<O, CapacityValue> tableCell) {
        Long threshold = this.settingsService.loadSettings(GeneralSettingsPane.CAPACITY_THRESHOLD);
        CapacityValue item = (CapacityValue)tableCell.getItem();
        StyleUtil.addStyleClass(tableCell, "text-highlight", item != null && threshold != null && threshold.compareTo(item.getValue()) > 0);
    }
}

