/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table;

import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.column.ColumnColor;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.TableColumnWithDescription;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ExportableTableColumn;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ColoredTableColumn<S, T>
extends TableColumnWithDescription<S, T>
implements ExportableTableColumn {
    private boolean exportable = true;
    private final StringProperty colorAsCssBackgroundRule = new SimpleStringProperty();
    private ColumnColor color;

    public ColoredTableColumn() {
        this.setColor(ColumnColor.DEFAULT);
    }

    public void setColor(ColumnColor color) {
        this.color = color;
        if (color != null && color.getColor().getOpacity() > 0.0) {
            this.colorAsCssBackgroundRule.setValue("-fx-background-color: #" + color.getColor().toString().substring(2) + ";");
        } else {
            this.colorAsCssBackgroundRule.setValue(null);
        }
    }

    public ColumnColor getColor() {
        return this.color;
    }

    @Override
    public boolean isExportable() {
        return this.exportable;
    }

    public void setExportable(boolean exportable) {
        this.exportable = exportable;
    }

    public String getColorAsCssBackgroundRule() {
        return (String)this.colorAsCssBackgroundRule.get();
    }

    public ReadOnlyStringProperty colorAsCssBackgroundRuleProperty() {
        return this.colorAsCssBackgroundRule;
    }
}

