/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.order;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.BalancingGroupChoiceBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class OrderBalancingGroupChoiceBoxCellFactory
implements Callback<TableColumn<Order, Order>, TableCell<Order, Order>> {
    private final ApplicationContext applicationContext = FXMLLoaderWithContext.getAppContext();

    @Override
    public TableCell<Order, Order> call(TableColumn<Order, Order> param) {
        return new OrderBalancingGroupChoiceBoxTableCell(this.applicationContext);
    }

    protected static class OrderBalancingGroupChoiceBoxTableCell
    extends TableCell<Order, Order> {
        private final BalancingGroupChoiceBox graphic;

        protected OrderBalancingGroupChoiceBoxTableCell(ApplicationContext applicationContext) {
            this.graphic = new BalancingGroupChoiceBox(applicationContext);
            this.graphic.setListedItemsMode(BalancingGroupChoiceBox.ListedItemsMode.ONLY_OWN_BALANCING_GROUPS);
            this.graphic.valueProperty().addListener((observable2, oldValue, newValue) -> {
                if (this.getItem() != null) {
                    ((Order)this.getItem()).setBalancingGroup((BalancingGroup)newValue);
                }
            });
            this.graphic.disableProperty().bind(this.graphic.getHasOneOrLessItemsBinding());
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }

        @Override
        protected void updateItem(Order item, boolean empty) {
            super.updateItem(item, empty);
            if (item != null && !empty) {
                BalancingGroup value = item.getBalancingGroup();
                this.graphic.setContract(item.getContract());
                this.graphic.setValue(value);
                this.setGraphic(this.graphic);
            } else {
                this.graphic.valueProperty().unbind();
                this.graphic.setValue(null);
                this.graphic.setContract(null);
                this.setGraphic(null);
            }
        }
    }
}

