/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.BestOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdatable;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ExportableCellValue;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.List;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;

public class CollapsibleOrderbookEntries
implements ExportableCellValue {
    private final List<CommonOrderbookEntry> entries;
    private final Direction direction;
    private final BestOrderbookEntry bestOrderbookEntries;
    private final ObservableValue<Number> rowLimit;
    private final BatchUpdatable<CommonOrderbookEntry> batchUpdatable;
    private final Orderbook orderbook;
    private final Function<CommonOrderbookEntry, ObservableValue<String>> displayValueFunction;
    private final Function<CommonOrderbookEntry, Object> exportValueFunction;

    public CollapsibleOrderbookEntries(final ObservableValue<Boolean> collapsed, List<CommonOrderbookEntry> entries2, BatchUpdatable<CommonOrderbookEntry> batchUpdatable, final ObservableValue<Integer> givenRowLimit, Direction direction, BestOrderbookEntry bestOrderbookEntries, Orderbook orderbook, Function<CommonOrderbookEntry, ObservableValue<String>> displayValueFunction, Function<CommonOrderbookEntry, Object> exportValueFunction) {
        this.batchUpdatable = batchUpdatable;
        this.entries = entries2;
        this.direction = direction;
        this.bestOrderbookEntries = bestOrderbookEntries;
        this.displayValueFunction = displayValueFunction;
        this.exportValueFunction = exportValueFunction;
        this.rowLimit = new DependentBinding<Number>(this, new Observable[]{collapsed, givenRowLimit}){

            @Override
            protected Number computeValue() {
                return (Boolean)collapsed.getValue() != false ? 1 : (Integer)givenRowLimit.getValue();
            }
        };
        this.orderbook = orderbook;
    }

    @Override
    public List<Object> getExportedCellValue(LocalService localService) {
        long effectiveRowLimit = this.rowLimit.getValue().intValue() == -1 ? Long.MAX_VALUE : this.rowLimit.getValue().longValue();
        return this.entries.stream().limit(effectiveRowLimit).map(this.exportValueFunction).map(value -> {
            if (value instanceof LongDisplayValue) {
                return localService.format(((LongDisplayValue)value).getDisplayValue());
            }
            return value;
        }).toList();
    }

    public Direction getDirection() {
        return this.direction;
    }

    public List<CommonOrderbookEntry> getEntries() {
        return this.entries;
    }

    public BestOrderbookEntry getBestOrderbookEntries() {
        return this.bestOrderbookEntries;
    }

    public ObservableValue<Number> rowLimitProperty() {
        return this.rowLimit;
    }

    public BatchUpdatable<CommonOrderbookEntry> getBatchUpdatable() {
        return this.batchUpdatable;
    }

    public Orderbook getOrderbook() {
        return this.orderbook;
    }

    public Function<CommonOrderbookEntry, ObservableValue<String>> getDisplayValueFunction() {
        return this.displayValueFunction;
    }
}

