/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.tree;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ContractStatusWidget;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.SimpleLongDisplayValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.ContractTreeContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.ProductSpinnerItem;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DragAndDropService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import java.util.Collections;
import java.util.Map;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;

public class ContractTreeCellFactory
implements Callback<TreeView<Object>, TreeCell<Object>> {
    protected static final double GRAPHIC_TEXT_GAP = 10.0;
    private final ApplicationContext applicationContext;
    private final ContractTreeContext contractTreeContext;
    private final Map<Product, SimpleLongDisplayValueField> productStepSizes;

    public ContractTreeCellFactory(ApplicationContext applicationContext, ContractTreeContext contractTreeContext, Map<Product, SimpleLongDisplayValueField> productStepSizes) {
        this.applicationContext = applicationContext;
        this.contractTreeContext = contractTreeContext;
        this.productStepSizes = productStepSizes;
    }

    @Override
    public InstrumentTreeCell call(TreeView<Object> param) {
        return new InstrumentTreeCell(this.applicationContext, this.contractTreeContext, this.productStepSizes);
    }

    protected static class InstrumentTreeCell
    extends TreeCell<Object> {
        private final ContractTreeContext contractTreeContext;
        private final DragAndDropService dragAndDropService;
        private final Map<Product, SimpleLongDisplayValueField> productStepSizes;

        public InstrumentTreeCell(ApplicationContext applicationContext, ContractTreeContext contractTreeContext, Map<Product, SimpleLongDisplayValueField> productStepSizes) {
            this.contractTreeContext = contractTreeContext;
            this.productStepSizes = productStepSizes;
            this.dragAndDropService = applicationContext.getService(DragAndDropService.class);
            this.setContentDisplay(ContentDisplay.LEFT);
            this.setGraphicTextGap(10.0);
        }

        @Override
        protected void updateItem(Object item, boolean empty) {
            super.updateItem(item, empty);
            this.reset();
            if (item instanceof Contract) {
                this.loadContract((Contract)item);
            } else if (item instanceof Product) {
                this.loadProduct((Product)item);
            }
        }

        private void reset() {
            this.textProperty().unbind();
            this.setText(null);
            this.setGraphic(null);
            this.setContextMenu(null);
            this.setOnMouseClicked(null);
            this.setOnDragDetected(null);
        }

        private void loadProduct(Product product) {
            if (this.contractTreeContext.areProductsSubscribable()) {
                CheckBox checkBox = new CheckBox(product.getDisplayName());
                checkBox.setMnemonicParsing(false);
                checkBox.setSelected(this.contractTreeContext.isSubscribed(product));
                checkBox.selectedProperty().addListener((observable2, wasSelected, isSelected) -> this.productCheckboxChanged(product, checkBox));
                if (this.contractTreeContext.areProductsSteppable()) {
                    this.setGraphic(new ProductSpinnerItem(checkBox, this.productStepSizes.get(product)));
                } else {
                    this.setGraphic(checkBox);
                }
            } else {
                this.setText(product.getDisplayName());
            }
            if (this.contractTreeContext.isSelectable(product)) {
                MenuItem addAllMenuItem = new MenuItem(Util.getLabel("commons_addAll"));
                addAllMenuItem.setOnAction(event -> this.productSelected(product));
                this.setContextMenu(new ContextMenu(addAllMenuItem));
                this.setOnMouseClicked(event -> this.productClicked((MouseEvent)event, product));
            }
            this.setOnDragDetected(event -> this.productDragStarted((MouseEvent)event, product));
        }

        protected void productDragStarted(MouseEvent event, Product product) {
            Dragboard dragboard = this.startDragAndDrop(TransferMode.ANY);
            this.dragAndDropService.setProductList(dragboard, Collections.singletonList(product));
            event.consume();
        }

        private void productClicked(MouseEvent event, Product product) {
            if (event.getClickCount() == 2 && event.getButton() == MouseButton.PRIMARY) {
                this.productSelected(product);
            }
        }

        private void productSelected(Product product) {
            this.contractTreeContext.productSelected(product);
        }

        private void productCheckboxChanged(Product product, CheckBox checkBox) {
            if (checkBox.isSelected()) {
                this.contractTreeContext.productSubscribed(product);
            } else {
                this.contractTreeContext.productUnsubscribed(product);
            }
        }

        private void loadContract(Contract contract) {
            this.textProperty().bind(new WeakObservableValue<String>(contract.nameProperty()));
            ContractStatusWidget statusWidget = new ContractStatusWidget();
            statusWidget.valueProperty().bind(new WeakObservableValue<ContractStatus>(contract.getCompoundStatus().contractStatusProperty()));
            statusWidget.descriptionProperty().bind(new WeakObservableValue<String>(contract.getCompoundStatus().descriptionProperty()));
            this.setGraphic(statusWidget);
            this.setOnMouseClicked(event -> this.contractClicked((MouseEvent)event, contract));
            this.setOnDragDetected(event -> this.contractDragStarted((MouseEvent)event, contract));
        }

        protected void contractDragStarted(MouseEvent mouseEvent, Contract contract) {
            Dragboard db = this.startDragAndDrop(TransferMode.ANY);
            this.dragAndDropService.setContractList(db, Collections.singletonList(contract));
            mouseEvent.consume();
        }

        private void contractClicked(MouseEvent event, Contract contract) {
            if (event.getClickCount() == 2 && event.getButton() == MouseButton.PRIMARY && this.contractTreeContext.isSelectable(contract)) {
                this.contractTreeContext.contractSelected(contract);
            }
        }
    }
}

