/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.overrides;

import com.deutscheboerse.comxerv.comtrader.core.entity.SystemInfo;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractOverrideConfigurationsExecutorImpl {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOverrideConfigurationsExecutorImpl.class);
    public static final String GUI_OVERRIDES_APPLICATION_PROPERTY = "guiOverrides";
    protected final JSONObject overrides;
    final ApplicationConfigurationService applicationConfigurationService;

    public AbstractOverrideConfigurationsExecutorImpl(EventBus eventBus, ApplicationConfigurationService applicationConfigurationService) {
        this.applicationConfigurationService = applicationConfigurationService;
        this.overrides = this.parseJSONFile(applicationConfigurationService.getApplicationProperty(GUI_OVERRIDES_APPLICATION_PROPERTY));
        eventBus.register(this);
    }

    @Subscribe
    public void handleLogoutEvent(LogoutEvent event) {
        this.overrides.clear();
        this.overrides.putAll(this.parseJSONFile(this.applicationConfigurationService.getApplicationProperty(GUI_OVERRIDES_APPLICATION_PROPERTY)));
    }

    @Subscribe
    public void handleLoadingFinishedEvent(LoadingFinishedEvent loadingFinishedEvent) {
        SystemInfo systemInfo = loadingFinishedEvent.getSession().getExchange().getSystemInfo();
        List<JSONObject> collect = systemInfo.getOverridePath().stream().map(this::parseJSONFile).toList();
        for (JSONObject jsonObject : collect) {
            Set entries2 = jsonObject.entrySet();
            for (Map.Entry entry : entries2) {
                if (!this.overrides.containsKey(entry.getKey())) {
                    this.overrides.put(entry.getKey(), entry.getValue());
                    continue;
                }
                ((JSONArray)this.overrides.get(entry.getKey())).addAll((JSONArray)entry.getValue());
            }
        }
    }

    public JSONObject parseJSONFile(String guiOverridesPath) {
        JSONObject jSONObject;
        block9: {
            LOG.info("Loading GUI overrides: {}", (Object)guiOverridesPath);
            URL overridesResource = AbstractOverrideConfigurationsExecutorImpl.class.getResource("/" + guiOverridesPath);
            if (overridesResource == null) {
                return new JSONObject();
            }
            InputStream overridesStream = overridesResource.openStream();
            try {
                JSONObject json = (JSONObject)JSONValue.parse(IOUtils.toString(overridesStream, StandardCharsets.UTF_8));
                JSONObject parsedOverrides = json.getOrDefault("overrides", new JSONObject());
                JSONArray parsedIncludes = json.getOrDefault("includes", new JSONArray());
                parsedIncludes.forEach(includePath -> this.addJSONEntries(parsedOverrides, this.parseJSONFile((String)includePath)));
                jSONObject = parsedOverrides;
                if (overridesStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (overridesStream != null) {
                        try {
                            overridesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Unable to load gui overrides!", e);
                    return new JSONObject();
                }
            }
            overridesStream.close();
        }
        return jSONObject;
    }

    private void addJSONEntries(JSONObject to, JSONObject from) {
        from.forEach((key, value) -> {
            JSONArray jsonArray = to.getOrDefault(key, new JSONArray());
            jsonArray.addAll((JSONArray)value);
            to.put(key, jsonArray);
        });
    }
}

