/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui;

import com.deutscheboerse.comxerv.comtrader.jfx.overrides.functional.FieldsToOverrideResolver;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AbstractOverrideGuiStrategy;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.scene.Node;
import org.json.simple.JSONObject;

public class AbstractNodeOverrideGuiStrategy<T extends Node, S extends Node>
extends AbstractOverrideGuiStrategy<T, S> {
    public AbstractNodeOverrideGuiStrategy(FieldsToOverrideResolver<T, S> fieldsToOverrideResolver) {
        super(fieldsToOverrideResolver, Node::getId);
    }

    @Override
    public void apply(T fieldValue, String overrideId, JSONObject json) {
        super.apply(fieldValue, overrideId, json);
        Map<String, List<JSONObject>> overrides = this.groupByKey(json, overrideId);
        for (Map.Entry<String, List<JSONObject>> overrideEntry : overrides.entrySet()) {
            boolean isHide = overrideEntry.getValue().stream().map(override -> override.get("op")).anyMatch("hide"::equals);
            boolean isShow = overrideEntry.getValue().stream().map(override -> override.get("op")).anyMatch("show"::equals);
            if (isHide) {
                Optional.ofNullable(((Node)fieldValue).lookup("#" + overrideEntry.getKey())).ifPresent(node -> node.setVisible(false));
            }
            if (!isShow) continue;
            Optional.ofNullable(((Node)fieldValue).lookup("#" + overrideEntry.getKey())).ifPresent(node -> node.setVisible(true));
        }
    }
}

