/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.domain.query.UserQueries;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.service.ComponentAccessService;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;

@Singleton
public class ComponentAccessServiceImpl
implements ComponentAccessService {
    private final UserService userService;
    private final UserQueries userQueries;
    private final AssignmentService assignmentService;

    @Inject
    public ComponentAccessServiceImpl(ApplicationContext appContext) {
        this.userService = appContext.getService(UserService.class);
        this.userQueries = appContext.getService(UserQueries.class);
        this.assignmentService = appContext.getService(AssignmentService.class);
    }

    @Override
    public boolean isComponentAllowedForCurrentUser(Class<? extends AbstractPanel> clazz) {
        DraggableComponent annotation = clazz.getAnnotation(DraggableComponent.class);
        if (annotation.hasPublicAccess()) {
            return true;
        }
        List<String> componentAllowedForRoles = Arrays.asList(annotation.forUserWithUserRole());
        return componentAllowedForRoles.stream().anyMatch(this::anyCurrentUserHasRole);
    }

    private boolean anyCurrentUserHasRole(String role) {
        if (this.userService.getOwnUserRoles().hasRole(role)) {
            return true;
        }
        if ("ROLE_MARKET_MAKER".equals(role)) {
            return this.anyCurrentUserHasRoleOnBehalf(role);
        }
        return false;
    }

    private boolean anyCurrentUserHasRoleOnBehalf(String role) {
        User user = (User)this.userService.currentUserProperty().get();
        if (user == null || !user.getRoles().isOnBehalf() && !user.getRoles().isBroker()) {
            return false;
        }
        Sets.SetView<String> bgIds = Sets.union(user.getBalancingGroupIds(), this.assignmentService.getAssignedBgIdsForBroker(user));
        DataQuery<User> users = this.userQueries.findActiveTradersByBalancingGroupIds(bgIds);
        return users.getAll().anyMatch(u -> u.getRoles().hasRole(role));
    }
}

