/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service;

import com.deutscheboerse.comxerv.comtrader.jfx.components.image.ImageFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.service.WindowService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.StyleService;
import com.deutscheboerse.comxerv.comtrader.util.ImageConstants;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.stage.Window;

@Singleton
public class WindowServiceImpl
implements WindowService {
    private final StyleService styleService;
    private static final EventHandler<MouseEvent> BLOCK_MOUSE_EVENT_FILTER = Event::consume;

    @Inject
    public WindowServiceImpl(StyleService styleService) {
        this.styleService = styleService;
    }

    @Override
    public void decorateWindow(Window window) {
        this.styleService.registerWindowForStyleSwitching(window);
        if (window instanceof Stage) {
            ((Stage)window).getIcons().add(ImageFactory.getImage(ImageConstants.LOGO_ICON_64_X_64));
        }
        window.focusedProperty().addListener((observable2, wasFocused, isFocused) -> this.windowFocusChanged(window, (Boolean)isFocused));
        this.windowFocusChanged(window, window.isFocused());
    }

    private void windowFocusChanged(Window window, Boolean isFocused) {
        if (isFocused.booleanValue()) {
            window.removeEventFilter(MouseEvent.MOUSE_MOVED, BLOCK_MOUSE_EVENT_FILTER);
        } else {
            window.addEventFilter(MouseEvent.MOUSE_MOVED, BLOCK_MOUSE_EVENT_FILTER);
        }
    }
}

