/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.csv;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.AbstractOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideExcelConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.ExcelStrategiesSetup;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ExportableCellValue;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ExportableTableColumn;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ExportableView;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ImportExportService;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.csv.ClipboardExportWriter;
import com.deutscheboerse.comxerv.comtrader.service.csv.ClipboardPrepareImportService;
import com.deutscheboerse.comxerv.comtrader.service.csv.CsvExportWriter;
import com.deutscheboerse.comxerv.comtrader.service.csv.CsvPrepareImportService;
import com.deutscheboerse.comxerv.comtrader.service.csv.ExportService;
import com.deutscheboerse.comxerv.comtrader.service.csv.ExportWriter;
import com.deutscheboerse.comxerv.comtrader.service.csv.HTMLExportWriter;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ErrorCollector;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderImportService;
import com.deutscheboerse.comxerv.comtrader.util.CleanPath;
import com.deutscheboerse.comxerv.comtrader.util.FileUtil;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.WriterOutputStream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ImportExportServiceImpl
implements ImportExportService {
    private static final Logger LOG = LoggerFactory.getLogger(ImportExportServiceImpl.class);
    private static final int BUFF_SIZE_1MB = 0x100000;
    private static final long EXPORT_TO_FILE_TIMEOUT_IN_SECONDS = 60L;
    private final ApplicationContext appContext;
    private final UserAlertService userAlertService;
    private final MessagePublisher messagePublisher;
    private final LocalService localService;
    private final OverrideExcelConfigurationsExecutor overrideExcelConfigurationsService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ExportWriter htmlExportWriter;
    private File lastSelectedDir;

    @Inject
    public ImportExportServiceImpl(ApplicationContext appContext) {
        this.appContext = appContext;
        this.localService = appContext.getService(LocalService.class);
        this.htmlExportWriter = appContext.getService(HTMLExportWriter.class);
        this.scheduledExecutorService = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.messagePublisher = appContext.getService(MessagePublisher.class);
        this.overrideExcelConfigurationsService = appContext.getService(OverrideExcelConfigurationsExecutor.class);
    }

    public List<Order> parseOrders(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            ErrorCollector errorCollector = new ErrorCollector();
            List<List<String>> preparedData = this.appContext.getService(CsvPrepareImportService.class).prepareImport(inputStream, errorCollector);
            List<Order> orders = this.appContext.getService(OrderImportService.class).importData(preparedData, errorCollector);
            if (errorCollector.isEmpty()) {
                List<Order> list = orders;
                return list;
            }
            this.handleImportErrors(errorCollector);
            List<Order> list = Collections.emptyList();
            return list;
        }
    }

    @Override
    public List<Order> importFromClipboard() {
        try {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            String content = clipboard.getString();
            ErrorCollector errorCollector = new ErrorCollector();
            List<List<String>> preparedData = this.appContext.getService(ClipboardPrepareImportService.class).prepareImport(IOUtils.toInputStream(content, StandardCharsets.UTF_8), errorCollector);
            List<Order> orders = this.appContext.getService(OrderImportService.class).importData(preparedData, errorCollector);
            if (errorCollector.isEmpty()) {
                return orders;
            }
            this.handleImportErrors(errorCollector);
            return Collections.emptyList();
        }
        catch (Exception e) {
            LOG.error("Error while importing data from clipboard.", e);
            this.userAlertService.showConfirmationDialog(Util.getLabel("commons_importError_exclamation"), Util.getLabel("importException_readErrorDuringClipboardImport"), UserAlertService.Flag.ERROR);
            return Collections.emptyList();
        }
    }

    private void handleImportErrors(ErrorCollector errorCollector) {
        this.messagePublisher.publishMessage(Util.getLabel("importException_errorDuringImport_short"), MessageSeverity.HIGH);
        if (LOG.isErrorEnabled()) {
            LOG.error(errorCollector.prepareErrorsForPopup());
        }
        this.userAlertService.showConfirmationDialog(Util.getLabel("commons_importError_exclamation"), Util.getLabel("importException_errorDuringImport"), errorCollector.prepareErrorsForPopup(), UserAlertService.Flag.ERROR);
    }

    @Override
    public List<Order> importFromCsvFile(Window parent) {
        File file = this.showFilePopup(parent, ImportExportService.IODirection.IMPORT, null);
        if (file != null) {
            try {
                return this.parseOrders(file);
            }
            catch (IOException e) {
                LOG.error("Error while importing orders.", e);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public <S> CompletableFuture<Void> exportToCsvFile(ExportableView<S> view, Window parent, @Nullable String initialFileName) {
        List<String> columnNames = view.getColumnNames();
        return CompletableFuture.supplyAsync(() -> this.getExportedData(view), this.scheduledExecutorService).thenAccept(exportData -> this.exportToCsv((List<List<Object>>)exportData, columnNames, parent, initialFileName));
    }

    @Override
    public <S> CompletableFuture<Void> exportToClipboard(ExportableView<S> view) {
        List<String> columnNames = view.getColumnNames();
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.getExportedData(view), this.scheduledExecutorService).thenApply(exportData -> this.prepareDataForClipboard((List<List<Object>>)exportData, columnNames))).thenAcceptAsync(Clipboard.getSystemClipboard()::setContent, FxUtil.getJFXExecutor());
    }

    @Override
    public CompletableFuture<File> exportCollapsibleOrderbookToCsvFile(TableView<?> tableView, Window parent, @Nullable String initialFileName) {
        List<List<Object>> exportedData = this.getDataOfCollapsibleOrderbook(tableView);
        List<String> columnNames = this.getHeaderOfCollapsibleOrderbook(tableView);
        return this.exportToCsv(exportedData, columnNames, parent, initialFileName);
    }

    @Override
    public CompletableFuture<Void> exportCollapsibleOrderbookToClipboard(TableView<?> tableView) {
        List<String> columnNames = this.getHeaderOfCollapsibleOrderbook(tableView);
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.getDataOfCollapsibleOrderbook(tableView), this.scheduledExecutorService).thenApply(exportData -> this.prepareDataForClipboard((List<List<Object>>)exportData, columnNames))).thenAcceptAsync(Clipboard.getSystemClipboard()::setContent, FxUtil.getJFXExecutor());
    }

    @Override
    public CompletableFuture<File> exportOrderbookPanesToCsvFile(List<AbstractOrderbookPane> data, Window parent, @Nullable String initialFileName) {
        List<List<Object>> exportedData = this.getDataOfOrderbookPanes(data);
        return this.exportToCsv(exportedData, Collections.emptyList(), parent, initialFileName);
    }

    @Override
    public CompletableFuture<Void> exportOrderbookPanesToClipboard(List<AbstractOrderbookPane> data) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.getDataOfOrderbookPanes(data), this.scheduledExecutorService).thenApply(exportData -> this.prepareDataForClipboard((List<List<Object>>)exportData, Collections.emptyList()))).thenAcceptAsync(Clipboard.getSystemClipboard()::setContent, FxUtil.getJFXExecutor());
    }

    @Override
    public CompletableFuture<Void> exportHalftradesToCsvFile(Stream<HalfTrade> trades, Window parent, @Nullable String initialFileName) {
        List<String> tradeCsvColums = List.of("Leg Side", "Trade Id", "Contract Name", "Quantity", "Price", "State");
        return this.exportToCsv(this.tradeData(trades), tradeCsvColums, parent, initialFileName).thenAcceptAsync(FileUtil::openFutureFileSilent, FxUtil.getJFXExecutor());
    }

    private List<List<Object>> tradeData(Stream<HalfTrade> trades) {
        return trades.map(t -> List.of(t.getDirection(), t.getTradeId(), t.getContract().getDisplayName(), t.getQuantity(), t.getPrice(), t.getTradeState())).toList();
    }

    private CompletableFuture<File> exportToCsv(List<List<Object>> exportedData, List<String> columnNames, Window parent, String initialFileName) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.showFilePopup(parent, ImportExportService.IODirection.EXPORT, initialFileName), FxUtil.getJFXExecutor()).thenApplyAsync(file -> this.exportDataToFile((File)file, columnNames, exportedData), (Executor)this.scheduledExecutorService)).orTimeout(60L, TimeUnit.SECONDS).whenComplete((file, ex) -> {
            if (ex == null && file != null) {
                LOG.info("File exported: {}", file);
            } else if (ex == null) {
                LOG.info("Export cancelled");
            } else {
                LOG.error("Error exporting file", (Throwable)ex);
                this.showExportToFileFailedMessage((File)file);
            }
        });
    }

    private File exportDataToFile(@Nullable File file, List<String> columnNames, List<List<Object>> exportedData) {
        if (file != null) {
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file), 0x100000);){
                ExportService exportService = new ExportService(outputStream, columnNames, exportedData, new CsvExportWriter());
                exportService.exportData();
            }
            catch (IOException e) {
                LOG.error("Error while exporting data.", e);
                FxUtil.runInFxThread(() -> this.showExportToFileFailedMessage(file));
            }
        }
        return file;
    }

    private void showExportToFileFailedMessage(File file) {
        this.userAlertService.showConfirmationDialog(Util.getLabel("exportException_writeFailed_windowHeader"), Util.getLabel("exportException_writeFailed_message", file), UserAlertService.Flag.ERROR);
    }

    private <S> List<List<Object>> getExportedData(ExportableView<S> view) {
        List<S> items = view.getItems();
        ArrayList<List<Object>> data = new ArrayList<List<Object>>(items.size());
        for (S item : items) {
            ArrayList<Object> rowData = new ArrayList<Object>();
            for (int i = 0; i < view.getColumnNames().size(); ++i) {
                Object cellData = view.getColumnData(i, item);
                if (cellData == null) {
                    rowData.add(null);
                    continue;
                }
                if (cellData instanceof DisplayName) {
                    rowData.add(((DisplayName)cellData).getDisplayName());
                    continue;
                }
                if (cellData instanceof LongDisplayValue) {
                    rowData.add(this.localService.format(((LongDisplayValue)cellData).getDisplayValue()));
                    continue;
                }
                if (cellData instanceof Number) {
                    rowData.add(this.localService.format(new BigDecimal(((Number)cellData).toString())));
                    continue;
                }
                if (cellData instanceof DateTime) {
                    rowData.add(this.localService.formatDateTime((DateTime)cellData));
                    continue;
                }
                rowData.add(cellData.toString());
            }
            data.add(rowData);
        }
        return data;
    }

    private List<List<Object>> getDataOfCollapsibleOrderbook(TableView<?> tableView) {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        for (int i = 0; i < tableView.getItems().size(); ++i) {
            List<List<Object>> rowData = this.getCollapsibleOrderbookColumns(tableView, i);
            int maxDepth = rowData.stream().mapToInt(List::size).max().orElse(0);
            for (int j = 0; j < maxDepth; ++j) {
                ArrayList<Object> printLineData = new ArrayList<Object>();
                for (List<Object> lineColumn : rowData) {
                    if (j < lineColumn.size()) {
                        printLineData.add(lineColumn.get(j));
                        continue;
                    }
                    printLineData.add(null);
                }
                data.add(printLineData);
            }
        }
        return data;
    }

    private List<List<Object>> getCollapsibleOrderbookColumns(TableView<?> tableView, int i) {
        ArrayList<List<Object>> rowData = new ArrayList<List<Object>>();
        for (TableColumn tableColumn : tableView.getColumns()) {
            if (!this.isColumnOfCollapsibleOrderbookVisible(tableColumn)) continue;
            Object cellData = tableColumn.getCellData(i);
            if (cellData == null) {
                rowData.add(Collections.emptyList());
                continue;
            }
            if (cellData instanceof DisplayName) {
                rowData.add(Collections.singletonList(((DisplayName)cellData).getDisplayName()));
                continue;
            }
            if (cellData instanceof LongDisplayValue) {
                rowData.add(Collections.singletonList(this.localService.format(((LongDisplayValue)cellData).getDisplayValue())));
                continue;
            }
            if (cellData instanceof Number) {
                rowData.add(Collections.singletonList(this.localService.format(new BigDecimal(((Number)cellData).toString()))));
                continue;
            }
            if (cellData instanceof DateTime) {
                rowData.add(Collections.singletonList(this.localService.formatDateTime((DateTime)cellData)));
                continue;
            }
            if (cellData instanceof ExportableCellValue) {
                ExportableCellValue exportableCellValue = (ExportableCellValue)cellData;
                rowData.add(exportableCellValue.getExportedCellValue(this.localService));
                continue;
            }
            rowData.add(Collections.singletonList(cellData.toString()));
        }
        return rowData;
    }

    private List<String> getHeaderOfCollapsibleOrderbook(TableView<?> tableView) {
        ArrayList<String> header = new ArrayList<String>();
        for (TableColumn tableColumn : tableView.getColumns()) {
            if (!this.isColumnOfCollapsibleOrderbookVisible(tableColumn)) continue;
            header.add(tableColumn.getText());
        }
        return header;
    }

    private List<List<Object>> getDataOfOrderbookPanes(List<AbstractOrderbookPane> paneList) {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        ExcelStrategiesSetup excelStrategiesSetup = null;
        if (!paneList.isEmpty()) {
            excelStrategiesSetup = this.overrideExcelConfigurationsService.getExcelSetup(paneList.get(0));
        }
        for (AbstractOrderbookPane pane : paneList) {
            if (excelStrategiesSetup != null) {
                data.addAll(excelStrategiesSetup.getOverviewStrategy().consume(pane.getOrderbook()));
                if (pane.isExpanded()) {
                    data.addAll(excelStrategiesSetup.getHeadersStrategy().consume(pane.getOrderbook()));
                    data.addAll(excelStrategiesSetup.getRowsStrategy().consume((ExtendedOrderbookEntry)((Object)pane)));
                }
            }
            data.add(Collections.emptyList());
        }
        return data;
    }

    private boolean isColumnOfCollapsibleOrderbookVisible(TableColumn<?, ?> tableColumn) {
        return tableColumn.isVisible() && tableColumn instanceof ExportableTableColumn && ((ExportableTableColumn)((Object)tableColumn)).isExportable();
    }

    private Map<DataFormat, Object> prepareDataForClipboard(List<List<Object>> exportedData, List<String> columnNames) {
        HashMap<DataFormat, Object> content = new HashMap<DataFormat, Object>(2);
        try {
            StringWriter plaintextStringWriter = new StringWriter();
            WriterOutputStream plaintextOutputStream = new WriterOutputStream((Writer)plaintextStringWriter, StandardCharsets.UTF_8);
            ExportService plaintextExportService = new ExportService(plaintextOutputStream, columnNames, exportedData, new ClipboardExportWriter());
            plaintextExportService.exportData();
            content.put(DataFormat.PLAIN_TEXT, plaintextStringWriter.toString());
            StringWriter htmlStringWriter = new StringWriter();
            WriterOutputStream htmlOutputStream = new WriterOutputStream((Writer)htmlStringWriter, StandardCharsets.UTF_8);
            ExportService htmlExportService = new ExportService(htmlOutputStream, columnNames, exportedData, this.htmlExportWriter);
            htmlExportService.exportData();
            content.put(DataFormat.HTML, htmlStringWriter.toString());
        }
        catch (IOException e) {
            LOG.error("Error while exporting to clipboard.", e);
        }
        return content;
    }

    @Override
    public File showFilePopup(Window window, ImportExportService.IODirection ioDirection, @Nullable String initialFileName) {
        File result;
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter(Util.getLabel("commons_csvFileFilter"), Arrays.asList("*.csv", "*.CSV")));
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter(Util.getLabel("csvService_anyFileFilterName"), Arrays.asList("*.*")));
        if (initialFileName != null) {
            fileChooser.setInitialFileName(initialFileName);
        }
        boolean lastSelectedDirIsValid = this.lastSelectedDir == null || !this.lastSelectedDir.exists();
        File initialDir = lastSelectedDirIsValid ? new File(CleanPath.cleanString(System.getProperty("user.home"))) : this.lastSelectedDir;
        fileChooser.setInitialDirectory(initialDir);
        String title = ioDirection == ImportExportService.IODirection.EXPORT ? Util.getLabel("commons_fileExportPrompt") : Util.getLabel("commons_fileImportPrompt");
        fileChooser.setTitle(title);
        File file = result = ioDirection == ImportExportService.IODirection.EXPORT ? fileChooser.showSaveDialog(window) : fileChooser.showOpenDialog(window);
        if (result != null) {
            this.lastSelectedDir = result.getParentFile();
            if (!result.getName().contains(".")) {
                result = new File(result.getAbsolutePath() + ".csv");
            }
        }
        return result;
    }
}

