/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.trade;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.EmptyOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryType;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu.OrderbookContextMenuFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.MarketSelectionEvent;
import com.deutscheboerse.comxerv.comtrader.jfx.service.trade.TradingActionService;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.action.OrderActionsService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingAction;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.event.MouseEventUtil;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;

@Singleton
public class TradingActionServiceImpl
implements TradingActionService {
    private final OwnQuantityLookupService ownQuantityLookupService;
    private final EventBus eventBus;
    private final OrderPopup orderPopup;
    private final OrderbookContextMenuFactory orderbookContextMenuFactory;
    private final OrderActionsService orderActionsService;
    private final TradingSettingsService tradingSettingsService;
    private final UserService userService;

    @Inject
    public TradingActionServiceImpl(ApplicationContext appContext) {
        this.ownQuantityLookupService = appContext.getService(OwnQuantityLookupService.class);
        this.eventBus = appContext.getService(EventBus.class);
        this.orderPopup = appContext.getService(OrderPopup.class);
        this.orderbookContextMenuFactory = appContext.getService(OrderbookContextMenuFactory.class);
        this.orderActionsService = appContext.getService(OrderActionsService.class);
        this.tradingSettingsService = appContext.getService(TradingSettingsService.class);
        this.userService = appContext.getService(UserService.class);
    }

    @Override
    public void doAction(MouseEvent mouseEvent, Orderbook orderbook) {
        if (this.getAction(mouseEvent, OrderbookEntryType.AGGREGATED) == TradingAction.MATCH) {
            this.doAction(mouseEvent, orderbook, Direction.SELL, OrderbookEntryType.AGGREGATED);
        } else {
            this.doAction(mouseEvent, orderbook, Direction.BUY, OrderbookEntryType.AGGREGATED);
        }
    }

    @Override
    public void doAction(MouseEvent mouseEvent, Orderbook orderbook, Direction direction, OrderbookEntryType orderbookEntryType) {
        this.doAction(mouseEvent, EmptyOrderbookEntry.create(orderbook, direction, orderbookEntryType), OrderActionsService.PreparedOrderQuantitySelector.FIRM);
    }

    @Override
    public void doAction(MouseEvent mouseEvent, CommonOrderbookEntry entry, OrderActionsService.PreparedOrderQuantitySelector quantitySelector) {
        Optional<Order> originalOrder;
        Node eventTarget = (Node)mouseEvent.getTarget();
        Contract contract = entry.getOrderbook().getContract();
        TradingAction tradingAction = this.getAction(mouseEvent, entry.getType());
        if (tradingAction == TradingAction.ADD) {
            Order preparedOrder = this.orderActionsService.createOrderFromOrderbookEntry(entry, quantitySelector);
            this.showOrderPopupOrLoadIntoOrderEntryPanel(preparedOrder, eventTarget);
        } else if (tradingAction == TradingAction.MATCH) {
            if (contract.getProduct().isLiftOrderProduct()) {
                Order preparedOrder = this.orderActionsService.createOrderFromOrderbookEntry(entry, quantitySelector);
                preparedOrder.setDirection(preparedOrder.getDirection().reverse());
                this.showLiftOrderPopup(preparedOrder, eventTarget);
            } else {
                Order preparedOrder = this.orderActionsService.createOrderFromOrderbookEntry(entry, quantitySelector);
                preparedOrder.setDirection(preparedOrder.getDirection().reverse());
                this.showOrderPopupOrLoadIntoOrderEntryPanel(preparedOrder, eventTarget);
            }
        } else if (tradingAction == TradingAction.SIMPLE_ADD) {
            Order preparedOrder = this.orderActionsService.createOrderFromOrderbookEntry(entry, quantitySelector);
            this.showSimpleOrderPopupOrLoadIntoOrderEntryPanel(preparedOrder, eventTarget);
        } else if (tradingAction == TradingAction.SIMPLE_MATCH) {
            Order preparedOrder = this.orderActionsService.createOrderFromOrderbookEntry(entry, quantitySelector);
            preparedOrder.setDirection(preparedOrder.getDirection().reverse());
            this.showSimpleOrderPopupOrLoadIntoOrderEntryPanel(preparedOrder, eventTarget);
        } else if (tradingAction == TradingAction.CONTEXT_MENU) {
            Window window = ((Node)mouseEvent.getTarget()).getScene().getWindow();
            this.displayContextMenu(window, entry, new Point2D(mouseEvent.getScreenX(), mouseEvent.getScreenY()), quantitySelector);
        } else if (tradingAction == TradingAction.MODIFY && (originalOrder = this.orderActionsService.getOriginalOrder(entry)).isPresent()) {
            this.modifyOrderEntry(originalOrder.get(), eventTarget);
        }
    }

    private void showOrderPopupOrLoadIntoOrderEntryPanel(Order preparedOrder, Node eventTarget) {
        MarketSelectionEvent selectionEvent = new MarketSelectionEvent(preparedOrder);
        this.eventBus.post(selectionEvent);
        if (!selectionEvent.wasProcessed()) {
            this.orderPopup.showExtendedOrderPopup(preparedOrder, false, eventTarget);
        }
    }

    private void showSimpleOrderPopupOrLoadIntoOrderEntryPanel(Order preparedOrder, Node eventTarget) {
        MarketSelectionEvent selectionEvent = new MarketSelectionEvent(preparedOrder);
        this.eventBus.post(selectionEvent);
        if (!selectionEvent.wasProcessed()) {
            this.orderPopup.showSimpleOrderPopup(preparedOrder, eventTarget);
        }
    }

    private void showLiftOrderPopup(Order preparedOrder, Node eventTarget) {
        this.orderPopup.showLiftOrderPopup(preparedOrder, eventTarget);
    }

    private void displayContextMenu(Window window, CommonOrderbookEntry entry, Point2D coordinates, OrderActionsService.PreparedOrderQuantitySelector quantitySelector) {
        ContextMenu menu = this.orderbookContextMenuFactory.createOrderbookContextMenu(entry, quantitySelector);
        menu.show(window, coordinates.getX(), coordinates.getY());
    }

    private void modifyOrderEntry(Order originalOrder, Node eventTarget) {
        if (this.ownQuantityLookupService.isOwnOrder(originalOrder)) {
            this.orderPopup.showExtendedOrderPopup(originalOrder, false, eventTarget);
        }
    }

    @Override
    public TradingAction getAction(MouseEvent mouseEvent, OrderbookEntryType currentEntry) {
        TradingAction action = null;
        if (MouseEventUtil.isOnlyMouseButton(mouseEvent, MouseButton.PRIMARY)) {
            action = this.tradingSettingsService.getTradingMouseActions().getLeftMouseAction(currentEntry);
        }
        if (MouseEventUtil.isOnlyMouseButton(mouseEvent, MouseButton.SECONDARY)) {
            action = this.tradingSettingsService.getTradingMouseActions().getRightMouseAction(currentEntry);
        }
        if (MouseEventUtil.isCtrlMouseButton(mouseEvent, MouseButton.PRIMARY)) {
            action = this.tradingSettingsService.getTradingMouseActions().getCtrlLeftMouseAction(currentEntry);
        }
        if (MouseEventUtil.isCtrlMouseButton(mouseEvent, MouseButton.SECONDARY)) {
            action = this.tradingSettingsService.getTradingMouseActions().getCtrlRightMouseAction(currentEntry);
        }
        if (MouseEventUtil.isShiftMouseButton(mouseEvent, MouseButton.PRIMARY)) {
            action = this.tradingSettingsService.getTradingMouseActions().getShiftLeftMouseAction(currentEntry);
        }
        if (MouseEventUtil.isShiftMouseButton(mouseEvent, MouseButton.SECONDARY)) {
            action = this.tradingSettingsService.getTradingMouseActions().getShiftRightMouseAction(currentEntry);
        }
        return this.getTradingActionsOfCurrentUser(currentEntry).contains(action) ? action : TradingAction.NO_ACTION;
    }

    @Override
    public Set<TradingAction> getTradingActionsOfCurrentUser(OrderbookEntryType OrderbookEntryType2) {
        Set<TradingAction> values2 = TradingAction.values(OrderbookEntryType2);
        if (this.userService.getCurrentUserRoles().isSalesUser()) {
            return EnumSet.of(TradingAction.NO_ACTION);
        }
        return values2;
    }
}

