/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.version;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.service.version.VersionMismatchErrorDialog;
import com.deutscheboerse.comxerv.comtrader.jfx.service.version.VersionMismatchWarningDialog;
import com.deutscheboerse.comxerv.comtrader.service.version.VersionMismatchAlertService;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JfxVersionMismatchAlertService
implements VersionMismatchAlertService {
    private static final Logger LOG = LoggerFactory.getLogger(JfxVersionMismatchAlertService.class);
    private final ApplicationContext appContext;

    @Inject
    public JfxVersionMismatchAlertService(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public void showVersionMismatchWarning(String currentVersion, String newVersion) {
        LOG.warn("Showing version mismatch warning. currentVersion={}, newVersion={}", (Object)currentVersion, (Object)newVersion);
        FxUtil.runInFxThread(() -> {
            VersionMismatchWarningDialog dialog = new VersionMismatchWarningDialog(this.appContext);
            dialog.show();
            dialog.startCounter();
        });
    }

    @Override
    public void showVersionMismatchError(String error) {
        LOG.warn("Showing version mismatch error. {}", (Object)error);
        FxUtil.runInFxThread(() -> {
            VersionMismatchErrorDialog dialog = new VersionMismatchErrorDialog(this.appContext);
            dialog.show();
        });
    }
}

