/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.EulaService;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EulaServiceImpl
implements EulaService {
    private static final Logger LOG = LoggerFactory.getLogger(EulaServiceImpl.class);
    protected static final SettingsService.Settings<List<AgreedEula>> EULA_SETTINGS = new SettingsService.Settings("eulaSettigs", new ArrayList());
    private static final Locale FALLBACK_LANGUAGE = Locale.ENGLISH;
    private final ApplicationContext applicationContext;
    private final List<EulaService.Eula> eulas;
    private final LocalService localService;
    private final SettingsService settingsService;

    @Inject
    public EulaServiceImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.localService = applicationContext.getService(LocalService.class);
        this.settingsService = applicationContext.getService(SettingsService.class);
        this.eulas = this.loadEulas();
    }

    private List<EulaService.Eula> loadEulas() {
        String availableEulas = this.applicationContext.getService(ApplicationConfigurationService.class).getApplicationProperty("availableEulas", "");
        Collection<Locale> availableLanguages = this.localService.getAvailableLanguages();
        return Splitter.on(",").omitEmptyStrings().splitToList(availableEulas).stream().map(this::loadEula).filter(Optional::isPresent).map(Optional::get).filter(eula -> availableLanguages.contains(eula.getLocale())).toList();
    }

    private Optional<EulaService.Eula> loadEula(String eulaVariant) {
        String[] langAndVersion = eulaVariant.split("_");
        if (langAndVersion.length == 3) {
            String language = langAndVersion[1];
            try {
                int version = Integer.parseInt(langAndVersion[2]);
                URL resource = EulaServiceImpl.class.getResource("/com/deutscheboerse/comxerv/comtrader/service/eula/" + eulaVariant + ".html");
                if (resource != null) {
                    return Optional.of(new EulaImpl(resource, new Locale(language), version));
                }
                LOG.warn("Eula {} specified but not available.", (Object)eulaVariant);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid eula version {}", (Object)langAndVersion[2]);
            }
        }
        LOG.warn("Invalid eula {}", (Object)eulaVariant);
        return Optional.empty();
    }

    @Override
    public void showEulaIfNeeded(String exchangeLogin, Consumer<EulaService.EulaDialogResult> eulaAccepted) {
        if (this.hasAlreadyAgreed(exchangeLogin)) {
            eulaAccepted.accept(EulaService.EulaDialogResult.ALREADY_AGREED);
        } else if (this.eulas.isEmpty()) {
            eulaAccepted.accept(EulaService.EulaDialogResult.NO_EULAS_CONFIGURED);
        } else {
            List<EulaService.Eula> eulasWithCurrentLocaleFirst = this.getEulasWithCurrentLocaleFirst();
            EulaService.EulaUi ui = this.applicationContext.getService(EulaService.EulaUi.class);
            ui.show(eulasWithCurrentLocaleFirst, eula -> this.handleEulaUiResult((Optional<EulaService.Eula>)eula, eulaAccepted, exchangeLogin));
        }
    }

    private List<EulaService.Eula> getEulasWithCurrentLocaleFirst() {
        LinkedList<EulaService.Eula> eulasReordered = new LinkedList<EulaService.Eula>(this.eulas);
        Locale configuredLocale = this.localService.getConfiguredLocale();
        Optional<EulaService.Eula> eulaInPreferedLanguage = this.eulas.stream().filter(e -> e.getLocale().equals(configuredLocale)).findFirst();
        if (eulaInPreferedLanguage.isPresent()) {
            eulasReordered.remove(eulaInPreferedLanguage.get());
            eulasReordered.add(0, eulaInPreferedLanguage.get());
        }
        return eulasReordered;
    }

    private void handleEulaUiResult(Optional<EulaService.Eula> eula, Consumer<EulaService.EulaDialogResult> eulaAccepted, String exchangeLogin) {
        eula.ifPresent(acceptedEula -> this.storeAgreedEula((EulaService.Eula)acceptedEula, exchangeLogin));
        eulaAccepted.accept(eula.isPresent() ? EulaService.EulaDialogResult.AGREE : EulaService.EulaDialogResult.DISAGREE);
    }

    private void storeAgreedEula(EulaService.Eula eula, String exchangeLogin) {
        ArrayList<AgreedEula> agreedEulas = new ArrayList<AgreedEula>((Collection)this.settingsService.loadSettings(EULA_SETTINGS));
        agreedEulas.add(new AgreedEula(eula.getVersion(), eula.getLocale(), exchangeLogin));
        this.settingsService.storeSettings(EULA_SETTINGS, agreedEulas);
    }

    private boolean hasAlreadyAgreed(String exchangeLogin) {
        Locale lang = this.localService.getConfiguredLocale();
        Optional<EulaService.Eula> eulaForCurrentLang = this.getEulaForLangOrDefault(lang);
        if (eulaForCurrentLang.isPresent()) {
            return this.settingsService.loadSettings(EULA_SETTINGS).stream().anyMatch(agreedEula -> this.eulaMatchesAgreedVersion((EulaService.Eula)eulaForCurrentLang.get(), (AgreedEula)agreedEula, exchangeLogin));
        }
        return false;
    }

    private boolean eulaMatchesAgreedVersion(EulaService.Eula eula, AgreedEula agreedEula, String exchangeLogin) {
        return agreedEula.exchangeLogin.equals(exchangeLogin) && agreedEula.verion == eula.getVersion() && agreedEula.locale.equals(eula.getLocale());
    }

    private Optional<EulaService.Eula> getEulaForLangOrDefault(Locale locale) {
        return Stream.of(this.getEulaByLocale(locale), this.getEulaByLocale(FALLBACK_LANGUAGE)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Optional<EulaService.Eula> getEulaByLocale(Locale locale) {
        return this.eulas.stream().filter(eula -> eula.getLocale().equals(locale)).findFirst();
    }

    protected static class EulaImpl
    implements EulaService.Eula {
        private final URL resource;
        private final Locale locale;
        private final int version;

        public EulaImpl(URL resource, Locale locale, int version) {
            this.resource = resource;
            this.locale = locale;
            this.version = version;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public URL getResource() {
            return this.resource;
        }

        @Override
        public Locale getLocale() {
            return this.locale;
        }
    }

    protected static class AgreedEula {
        private final int verion;
        private final Locale locale;
        private final String exchangeLogin;

        public AgreedEula(int verion, Locale locale, String exchangeLogin) {
            this.verion = verion;
            this.locale = locale;
            this.exchangeLogin = exchangeLogin;
        }
    }
}

