/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.MemoryService;
import com.deutscheboerse.comxerv.comtrader.service.info.MemoryInfo;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

@Singleton
public class MemoryServiceImpl
implements MemoryService {
    private static final long UPDATE_INTERVAL_IN_SECONDS = 3L;
    private final List<Consumer<String>> memoryUpdateConsumers = new CopyOnWriteArrayList<Consumer<String>>();
    private final MemoryInfo memoryInfo = new MemoryInfo();

    @Inject
    public MemoryServiceImpl(@WorkerExecutor ScheduledExecutorService scheduledExecutorService) {
        scheduledExecutorService.scheduleAtFixedRate(this::notifyConsumers, 0L, 3L, TimeUnit.SECONDS);
    }

    @Override
    public void registerForUpdates(Consumer<String> consumer) {
        this.memoryUpdateConsumers.add(consumer);
    }

    @Override
    public void unregisterForUpdates(Consumer<String> consumer) {
        this.memoryUpdateConsumers.remove(consumer);
    }

    private void notifyConsumers() {
        String memoryStatus = this.memoryInfo.getMemoryStatus();
        this.memoryUpdateConsumers.forEach(consumer -> consumer.accept(memoryStatus));
    }
}

