/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.service.event.PreLoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.PreLogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.UserDataResetEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;

@Singleton
public class ActiveExchangeImpl
implements ActiveExchange {
    private final ObjectProperty<Exchange> activeExchange = new SimpleObjectProperty<Exchange>();

    @Inject
    public ActiveExchangeImpl(ApplicationContext appContext) {
        appContext.getService(EventBus.class).register(this);
    }

    @Override
    public ObservableObjectValue<Exchange> getActiveExchange() {
        return this.activeExchange;
    }

    @Subscribe
    public void handlePreLoadingFinishedEvent(PreLoadingFinishedEvent event) {
        this.activeExchange.set(event.getSession().getExchange());
    }

    @Subscribe
    public void handlePreLogoutEvent(PreLogoutEvent event) {
        this.activeExchange.set(null);
    }

    @Subscribe
    public void handleUserDataResetEvent(UserDataResetEvent event) {
        this.activeExchange.set(null);
    }
}

