/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.rabbitmq.client.AMQP;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpUtil.class);
    public static final String MESSAGE_ENCODING = "UTF-8";
    public static final String GZIP_COMPRESSION_ENCODING = "gzip";
    public static final String EVENT_INDEX_AMQP_HEADER = "event-index";
    public static final String SERVER_TIMESTAMP = "server-timestamp";
    public static final String PMI_PROCESSING_TIME = "pmi-processing";
    public static final int SHORT_TIMEOUT = 10000;
    public static final int LONG_TIMEOUT = 60000;

    private AmqpUtil() {
    }

    public static byte[] decompressIfNeeded(AMQP.BasicProperties properties, byte[] body, String zipEncodingName) throws IOException {
        if (!zipEncodingName.equals(properties.getContentEncoding())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("received not compressed message: {} {}", (Object)properties.getCorrelationId(), (Object)body.length);
            }
            return body;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("received gzip message with size: {}", (Object)body.length);
        }
        ByteArrayInputStream baos = null;
        GZIPInputStream gzis = null;
        byte[] result = null;
        try {
            baos = new ByteArrayInputStream(body);
            gzis = new GZIPInputStream(baos);
            result = IOUtils.toByteArray((Reader)new InputStreamReader((InputStream)gzis, MESSAGE_ENCODING), Charset.forName(MESSAGE_ENCODING));
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Exception occurred while decompressing", e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(gzis);
                Util.closeQuietly(baos);
                throw throwable;
            }
        }
        Util.closeQuietly(gzis);
        Util.closeQuietly(baos);
        if (LOG.isDebugEnabled()) {
            LOG.debug("decompressed gzip message size: {}", (Object)result.length);
        }
        return result;
    }

    public static byte[] compressIfNeeded(AMQP.BasicProperties properties, byte[] body) throws IOException {
        if (!GZIP_COMPRESSION_ENCODING.equals(properties.getContentEncoding())) {
            return body;
        }
        LOG.debug("message to gzip with size: {}", (Object)body.length);
        byte[] result = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(body.length);
             GZIPOutputStream gzos = new GZIPOutputStream(baos);){
            gzos.write(body);
            gzos.close();
            result = baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception occurred while compressing", e);
        }
        LOG.debug("compressed gzip message size: {}", (Object)result.length);
        return result;
    }

    public static String toString(byte[] bytes) throws UnsupportedEncodingException {
        return bytes == null ? null : new String(bytes, MESSAGE_ENCODING);
    }

    public static String toStringSwallowException(byte[] bytes) {
        try {
            return bytes == null ? null : new String(bytes, MESSAGE_ENCODING);
        }
        catch (Exception e) {
            return "Conversion failed: " + e.getClass().getSimpleName() + " " + e.getMessage();
        }
    }

    public static Long getEventIndexHeaderFromProperties(AMQP.BasicProperties properties) {
        return properties.getHeaders() != null ? (Long)properties.getHeaders().get(EVENT_INDEX_AMQP_HEADER) : null;
    }

    public static Long getServerTimestampHeaderFromProperties(AMQP.BasicProperties properties) {
        return properties.getHeaders() != null ? (Long)properties.getHeaders().get(SERVER_TIMESTAMP) : null;
    }

    public static Long getPmiProcessingTimeHeaderFromProperties(AMQP.BasicProperties properties) {
        return properties.getHeaders() != null ? (Long)properties.getHeaders().get(PMI_PROCESSING_TIME) : null;
    }
}

